/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.util.concurrent.Supplier;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.connection.UserSuppliedConnectionProvider;
import org.springframework.beans.factory.DisposableBean;

public class ConfluenceConnectionProviderSupplier
implements Supplier<ConnectionProvider>,
DisposableBean {
    private final HibernateConfig hibernateConfig;
    private final ResettableLazyReference<ConnectionProvider> connectionProviderSupplier = new ResettableLazyReference<ConnectionProvider>(){

        protected ConnectionProvider create() throws Exception {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)Environment.getProperties());
            properties.putAll((Map<?, ?>)ConfluenceConnectionProviderSupplier.this.hibernateConfig.getHibernateProperties());
            return ConnectionProviderFactory.newConnectionProvider((Properties)properties);
        }
    };

    public ConfluenceConnectionProviderSupplier(HibernateConfig hibernateConfig) {
        this.hibernateConfig = Objects.requireNonNull(hibernateConfig);
    }

    public ConnectionProvider get() {
        if (this.connectionProviderSupplier.get() instanceof UserSuppliedConnectionProvider) {
            this.connectionProviderSupplier.reset();
        }
        return (ConnectionProvider)this.connectionProviderSupplier.get();
    }

    public void destroy() throws Exception {
        if (this.connectionProviderSupplier.isInitialized()) {
            ((ConnectionProvider)this.connectionProviderSupplier.get()).close();
        }
    }
}

