/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.hibernate.ConfluenceSharedConnectionProvider;
import bucket.core.persistence.hibernate.MappingResources;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.hibernate.adapter.HibernateBridgeMode;
import com.atlassian.hibernate.adapter.LocalSessionFactoryV2BridgeBean;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.connection.ConnectionProvider;
import org.springframework.beans.factory.annotation.Required;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryV2BridgeBean {
    private Iterable<String> mappingResources;
    private HibernateConfig hibernateConfig;
    private final Supplier<ConnectionProvider> connectionProviderSupplier;

    public ConfigurableLocalSessionFactoryBean(@Nonnull Supplier<ConnectionProvider> connectionProviderSupplier) {
        this.connectionProviderSupplier = Objects.requireNonNull(connectionProviderSupplier);
        super.setBridgeMode(HibernateBridgeMode.V2_COLD_START);
    }

    public Configuration newConfiguration() throws HibernateException {
        Configuration config = super.newConfiguration();
        config.addProperties(this.hibernateConfig.getHibernateProperties());
        Properties connectionProviderProperty = new Properties();
        connectionProviderProperty.put("atlassian.hibernate.connection.provider", this.connectionProviderSupplier.get());
        config.addProperties(connectionProviderProperty);
        config.setProperty("hibernate.connection.provider_class", ConfluenceSharedConnectionProvider.class.getName());
        this.setConfigLocation(null);
        super.setMappingResources((String[])Iterables.toArray(this.mappingResources, String.class));
        return config;
    }

    @Deprecated
    public MappingResources getMappingResources() {
        MappingResources mappingResources = new MappingResources();
        mappingResources.setMappings((List)ImmutableList.of(this.mappingResources));
        return mappingResources;
    }

    @Required
    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    @Deprecated
    public void setMappingResources(MappingResources mappingResources) {
        this.setCurrentMappingResources(mappingResources.getMappings());
    }

    @Required
    public void setCurrentMappingResources(Iterable<String> mappingResources) {
        this.mappingResources = mappingResources;
    }

    public Iterable<String> getCurrentMappingResources() {
        return this.mappingResources;
    }
}

