/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.quartz.jobs;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.quartz.jobs.AbstractJob;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueueFlushJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(TaskQueueFlushJob.class);
    private MultiQueueTaskManager taskManager;
    private String queueName;
    private TaskQueue queue;

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (StringUtils.isBlank((String)this.getQueueName())) {
            throw new IllegalStateException("Cannot execute this job as it has not been properly initialised. Please ensure queue name is set.");
        }
        if (!this.getTaskQueue().isFlushing()) {
            log.debug("Executing tasks for queue: " + this.getQueueName());
            this.getTaskQueue().flush();
        } else if (log.isDebugEnabled()) {
            log.debug("Task queue: " + this.getQueueName() + " was already being flushed - skipped this time.");
        }
    }

    private TaskQueue getTaskQueue() {
        if (this.queue == null) {
            this.queue = this.taskManager.getTaskQueue(this.getQueueName());
        }
        return this.queue;
    }

    @Deprecated
    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

