/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.event.events.group.GroupRemovingEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.GroupEventCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.GroupMembershipsUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.model.group.Group;
import java.util.List;
import java.util.Optional;

public class GroupRemovingEventCommand
extends GroupEventCommand<GroupRemovingEvent> {
    private final CrowdUserDirectoryHelper crowdUserDirectoryHelper;
    private final MembershipDao membershipDao;
    private final ConfluenceUserDao confluenceUserDao;

    public GroupRemovingEventCommand(UserGroupCommandSupport commandSupport, CrowdUserDirectoryHelper crowdUserDirectoryHelper, MembershipDao membershipDao, ConfluenceUserDao confluenceUserDao) {
        super(commandSupport);
        this.crowdUserDirectoryHelper = crowdUserDirectoryHelper;
        this.membershipDao = membershipDao;
        this.confluenceUserDao = confluenceUserDao;
    }

    public void processEvent(GroupRemovingEvent event, Object ... parameters) {
        Group group = event.getGroup();
        String groupName = group.getName();
        List<Directory> activeDirectoriesForGroup = this.crowdUserDirectoryHelper.getDirectoriesForGroup(groupName).stream().filter(Directory::isActive).toList();
        if (activeDirectoriesForGroup.size() == 1) {
            this.createMessage(event).ifPresent(journalMessage -> this.commandSupport.enqueueForUserManagement(UserJournalEntryTypes.GROUP_REMOVED_ENTRY.name(), (JournalMessage)journalMessage));
        }
        long directoryIdForGroup = group.getDirectoryId();
        this.checkAndRemoveGroupMembershipsForUser(directoryIdForGroup, groupName, event.getTimestamp());
        this.checkAndRemoveGroupMembershipsForGroup(directoryIdForGroup, groupName, event.getTimestamp());
    }

    public Optional<Command<GroupRemovingEvent, UserManagementInSyncModel>> newCommand(GroupRemovingEvent event) {
        return Optional.of(new GroupRemovingEventCommand(this.commandSupport, this.crowdUserDirectoryHelper, this.membershipDao, this.confluenceUserDao));
    }

    public Optional<Command<GroupRemovingEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.GROUP_REMOVED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new GroupRemovingEventCommand(this.commandSupport, this.crowdUserDirectoryHelper, this.membershipDao, this.confluenceUserDao)) : Optional.empty();
    }

    private void checkAndRemoveGroupMembershipsForUser(long directoryIdForGroup, String groupName, long timestamp) {
        List memberUsernames = this.membershipDao.search(directoryIdForGroup, GroupMembershipsUtil.allUsersInGroupQuery(groupName));
        memberUsernames.forEach(username -> {
            ConfluenceUser confluenceUser = this.confluenceUserDao.findByUsername(username);
            if (confluenceUser != null) {
                String userKey = confluenceUser.getKey().getStringValue();
                List<Directory> differentActiveDirectoriesForUser = this.crowdUserDirectoryHelper.getDirectoriesForUser(username).stream().filter(directory -> directory.isActive() && directory.getId() != directoryIdForGroup).toList();
                if (!differentActiveDirectoriesForUser.isEmpty()) {
                    differentActiveDirectoriesForUser.forEach(activeDirectory -> {
                        if (!this.membershipDao.isUserDirectMember(activeDirectory.getId().longValue(), username, groupName)) {
                            this.commandSupport.removeGroupMembershipForUser(groupName, timestamp, userKey);
                        }
                    });
                } else {
                    this.commandSupport.removeGroupMembershipForUser(groupName, timestamp, userKey);
                }
            }
        });
    }

    private void checkAndRemoveGroupMembershipsForGroup(long directoryIdForGroup, String groupName, long timestamp) {
        List memberGroupNames = this.membershipDao.search(directoryIdForGroup, GroupMembershipsUtil.allGroupsInGroupQuery(groupName));
        memberGroupNames.forEach(memberGroupName -> {
            List<Directory> differentActiveDirectoriesForGroup = this.crowdUserDirectoryHelper.getDirectoriesForGroup(memberGroupName).stream().filter(directory -> directory.isActive() && directory.getId() != directoryIdForGroup).toList();
            if (!differentActiveDirectoriesForGroup.isEmpty()) {
                differentActiveDirectoriesForGroup.forEach(activeDirectory -> {
                    if (!this.membershipDao.isGroupDirectMember(activeDirectory.getId().longValue(), memberGroupName, groupName)) {
                        this.commandSupport.removeGroupMembershipForGroup((String)memberGroupName, timestamp, groupName);
                    }
                });
            } else {
                this.commandSupport.removeGroupMembershipForGroup((String)memberGroupName, timestamp, groupName);
            }
        });
    }

    private Optional<JournalMessage> createMessage(GroupRemovingEvent event) {
        return Optional.of(new GroupJournalMessage(event.getTimestamp(), event.getGroup().getName()));
    }
}

