/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.GroupMembershipsEventCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupMembershipJournalMessage;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GroupMembershipsDeletedEventCommand
extends GroupMembershipsEventCommand<GroupMembershipsDeletedEvent> {
    public GroupMembershipsDeletedEventCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, CrowdUserDirectoryHelper crowdUserDirectoryHelper) {
        super(commandSupport, personFactory, crowdDirectoryEntityHelper, crowdUserDirectoryHelper);
    }

    private List<String> findEntitiesThatShouldBeProcessed(GroupMembershipsDeletedEvent event) {
        ArrayList<String> entitiesThatShouldBeProcessed = new ArrayList<String>();
        for (String entityName : event.getEntityNames()) {
            Optional childEntity;
            switch (event.getMembershipType()) {
                case GROUP_USER: {
                    childEntity = this.crowdDirectoryEntityHelper.findUserByName(event.getDirectoryId().longValue(), entityName);
                    break;
                }
                case GROUP_GROUP: {
                    childEntity = this.crowdDirectoryEntityHelper.findGroupByName(event.getDirectoryId().longValue(), entityName);
                    break;
                }
                default: {
                    this.logger.info("Unknown membership type {} encountered while processing group memberships deleted event in directory with ID [{}] ", (Object)event.getMembershipType(), (Object)event.getDirectoryId());
                    return entitiesThatShouldBeProcessed;
                }
            }
            if (childEntity.isPresent()) {
                if (!this.crowdDirectoryEntityHelper.isCanonical((DirectoryEntity)childEntity.get()) && (!this.crowdUserDirectoryHelper.isMembershipAggregationEnabled() || !this.isLastOne(entityName, event))) continue;
                entitiesThatShouldBeProcessed.add(entityName);
                continue;
            }
            this.logger.warn("Could not find child entity while processing group memberships delete event in directory with ID [{}]", (Object)event.getDirectoryId());
        }
        return entitiesThatShouldBeProcessed;
    }

    private boolean isLastOne(String entityName, GroupMembershipsDeletedEvent event) {
        return event.getMembershipType().equals((Object)MembershipType.GROUP_USER) ? !this.crowdDirectoryEntityHelper.userExistsInAnyDirectories(entityName, event.getGroupName()) : !this.crowdDirectoryEntityHelper.groupExistsInAnyDirectories(entityName, event.getGroupName());
    }

    public void processEvent(GroupMembershipsDeletedEvent event, Object ... parameters) {
        List<String> entitiesThatShouldBeProcessed = this.findEntitiesThatShouldBeProcessed(event);
        if (!entitiesThatShouldBeProcessed.isEmpty()) {
            GroupMembershipsDeletedEvent updatedEvent = new GroupMembershipsDeletedEvent(event.getSource(), event.getDirectory(), entitiesThatShouldBeProcessed, event.getGroupName(), event.getMembershipType());
            this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.GROUP_MEMBERSHIPS_DELETED_ENTRY), this.buildJournalMessage(updatedEvent));
        }
    }

    public Optional<Command<GroupMembershipsDeletedEvent, UserManagementInSyncModel>> newCommand(GroupMembershipsDeletedEvent event) {
        return Optional.of(new GroupMembershipsDeletedEventCommand(this.commandSupport, this.personFactory, this.crowdDirectoryEntityHelper, this.crowdUserDirectoryHelper));
    }

    public Optional<Command<GroupMembershipsDeletedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.GROUP_MEMBERSHIPS_DELETED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new GroupMembershipsDeletedEventCommand(this.commandSupport, this.personFactory, this.crowdDirectoryEntityHelper, this.crowdUserDirectoryHelper)) : Optional.empty();
    }

    @Override
    protected JournalMessage buildJournalMessage(GroupMembershipsDeletedEvent event) {
        return new GroupMembershipJournalMessage(event.getTimestamp(), event.getGroupName(), this.getEntityNames(event.getMembershipType(), event.getEntityNames()), event.getMembershipType());
    }
}

