/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement;

import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.group.GroupRemovingEvent;
import com.atlassian.confluence.event.events.user.PostUserRenamedEvent;
import com.atlassian.confluence.event.events.user.UserRemovingEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.AbstractRecorder;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.events.DirectoryOrderUpdatedEvent;
import com.atlassian.confluence.internal.api.incrementalsync.model.CommandFactory;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.usermanagement.UserManagementIncrementalSyncService;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class UserManagementRecorder
extends AbstractRecorder {
    private final EventPublisher eventPublisher;
    private final UserManagementIncrementalSyncService userManagementIncrementalSyncService;

    public UserManagementRecorder(EventPublisher eventPublisher, CommandFactory<UserManagementInSyncModel> userManagementCommandFactory, TransactionTemplate transactionTemplate, UserManagementIncrementalSyncService userManagementIncrementalSyncService) {
        super(transactionTemplate, userManagementCommandFactory);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.userManagementIncrementalSyncService = userManagementIncrementalSyncService;
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPostUserRenamedEvent(PostUserRenamedEvent event) {
        this.handleEvent(PostUserRenamedEvent.class, event);
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent event) {
        this.handleEvent(UserEditedEvent.class, event);
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent event) {
        this.handleEvent(GroupCreatedEvent.class, event);
    }

    @EventListener
    public void onGroupRemovingEvent(GroupRemovingEvent event) {
        this.handleEvent(GroupRemovingEvent.class, event);
    }

    @EventListener
    public void onGroupMembershipsCreatedDirectoryEvent(GroupMembershipsCreatedEvent event) {
        this.handleEvent(GroupMembershipsCreatedEvent.class, event);
    }

    @EventListener
    public void onGroupMembershipsDeletedDirectoryEvent(GroupMembershipsDeletedEvent event) {
        this.handleEvent(GroupMembershipsDeletedEvent.class, event);
    }

    @EventListener
    public void onUserRemovingEvent(UserRemovingEvent event) {
        this.handleEvent(UserRemovingEvent.class, event);
    }

    @EventListener
    public void onCrowdUserCreatedEvent(UserCreatedEvent event) {
        this.handleEvent(UserCreatedEvent.class, event);
    }

    @EventListener
    public void onDirectoryCreatedEvent(DirectoryCreatedEvent event) {
        this.handleEvent(DirectoryEvent.class, event);
    }

    @EventListener
    public void onDirectoryUpdatedEvent(DirectoryUpdatedEvent event) {
        this.handleEvent(DirectoryEvent.class, event);
    }

    @EventListener
    public void onDirectoryDeletedEvent(DirectoryDeletedEvent event) {
        this.handleEvent(DirectoryEvent.class, event);
    }

    @EventListener
    public void onDirectoryOrderUpdatedEvent(ApplicationDirectoryOrderUpdatedEvent event) {
        this.handleEvent(DirectoryEvent.class, new DirectoryOrderUpdatedEvent(event));
    }

    @EventListener
    public void onApplicationUpdatedEvent(ApplicationUpdatedEvent event) {
        this.handleEvent(ApplicationUpdatedEvent.class, event);
    }

    @EventListener
    public void onAsyncImportFinishedEvent(AsyncImportFinishedEvent event) {
        this.handleEvent(AsyncImportFinishedEvent.class, event);
    }

    protected UserManagementIncrementalSyncService getIncrementalSyncService() {
        return this.userManagementIncrementalSyncService;
    }
}

