/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionManager;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SubscriptionJournalStateStore;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncState;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncSubscription;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class ServerSubscriptionJournalStateStore
implements SubscriptionJournalStateStore {
    private static final Logger logger = LoggerFactory.getLogger(ServerSubscriptionJournalStateStore.class);
    private final String subscriptionContextKey;
    private final IncrementalSyncSubscriptionManager incrementalSyncSubscriptionManager;

    public ServerSubscriptionJournalStateStore(String subscriptionContextKey, IncrementalSyncSubscriptionManager incrementalSyncSubscriptionManager) {
        this.subscriptionContextKey = Objects.requireNonNull(subscriptionContextKey);
        this.incrementalSyncSubscriptionManager = Objects.requireNonNull(incrementalSyncSubscriptionManager);
    }

    public long getMostRecentId(@NonNull JournalIdentifier journalId) throws DataAccessException {
        if (!(journalId instanceof MultiSubscriptionPerJournalIdentifier)) {
            throw new IllegalArgumentException("Invalid journal identifier: " + String.valueOf(journalId));
        }
        MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)journalId;
        Optional<IncrementalSyncSubscription> value = this.getSubscriptionStateData(subscriptionJournalIdentifier);
        return value.orElseThrow(() -> new IllegalArgumentException("Subscription not found with journal id: " + String.valueOf(journalId))).getMostRecentId();
    }

    public void setMostRecentId(@NonNull JournalIdentifier journalId, long id) throws DataAccessException {
        if (!(journalId instanceof MultiSubscriptionPerJournalIdentifier)) {
            throw new IllegalArgumentException("Invalid journal identifier: " + String.valueOf(journalId));
        }
        MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)journalId;
        IncrementalSyncSubscription value = this.getSubscriptionStateData(subscriptionJournalIdentifier).orElseThrow(() -> new IllegalArgumentException("Subscription not found with journal id: " + String.valueOf(journalId)));
        value.setMostRecentId(id);
        this.saveSubscriptionStateData(value);
    }

    protected SubscriptionId saveSubscriptionStateData(IncrementalSyncSubscription value) {
        value.setContextKey(this.getSubscriptionContextKey());
        return this.incrementalSyncSubscriptionManager.store(value);
    }

    public void resetAllJournalStates() throws DataAccessException {
        this.incrementalSyncSubscriptionManager.removeAllSubscriptions(this.getSubscriptionContextKey());
    }

    @Override
    public void deactivateSubscription(@NonNull JournalIdentifier journalId) {
        if (!(journalId instanceof MultiSubscriptionPerJournalIdentifier)) {
            throw new IllegalArgumentException("Invalid journal identifier: " + String.valueOf(journalId));
        }
        MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)journalId;
        Optional<IncrementalSyncSubscription> value = this.getSubscriptionStateData(subscriptionJournalIdentifier);
        if (value.isEmpty()) {
            logger.warn("Cannot deactivate subscription for journal id {} because it does not exist", (Object)journalId);
            return;
        }
        value.ifPresent(subscriptionStateData -> {
            subscriptionStateData.setState(IncrementalSyncState.INACTIVE);
            this.incrementalSyncSubscriptionManager.store(subscriptionStateData);
        });
    }

    @Override
    public boolean removeSubscriptionStateData(@NonNull JournalIdentifier journalId) throws DataAccessException {
        if (!(journalId instanceof MultiSubscriptionPerJournalIdentifier)) {
            throw new IllegalArgumentException("Invalid journal identifier: " + String.valueOf(journalId));
        }
        MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)journalId;
        return this.incrementalSyncSubscriptionManager.removeSubscription(subscriptionJournalIdentifier.getSubscriptionId().getValue());
    }

    @Override
    public List<SubscriptionId> getAvailableSubscriptions() {
        return this.incrementalSyncSubscriptionManager.getSubscriptionsByContext(this.getSubscriptionContextKey(), IncrementalSyncState.ACTIVE).stream().map(IncrementalSyncSubscription::getId).map(SubscriptionId::of).toList();
    }

    @Override
    public List<SubscriptionId> getDeactivateSubscriptions() {
        return this.incrementalSyncSubscriptionManager.getSubscriptionsByContext(this.getSubscriptionContextKey(), IncrementalSyncState.INACTIVE).stream().map(IncrementalSyncSubscription::getId).map(SubscriptionId::of).toList();
    }

    @Override
    public void cleanUpSubscriptions(JournalIdentifier identifier, long ttlInMillis) {
        Instant instant = Instant.now().minus(ttlInMillis, ChronoUnit.MILLIS);
        this.incrementalSyncSubscriptionManager.removeExpiredSubscriptions(this.getSubscriptionContextKey(), instant);
    }

    @Override
    public SubscriptionId createNewSubscription(String subscriptionData) {
        if (!this.getAvailableSubscriptions().isEmpty()) {
            throw new UnsupportedOperationException("We don't support multiple subscriptions");
        }
        IncrementalSyncSubscription subscription = new IncrementalSyncSubscription();
        subscription.setState(IncrementalSyncState.NEW);
        SubscriptionId subscriptionId = this.saveSubscriptionStateData(subscription);
        subscription.setId(subscriptionId.getValue());
        subscription.setSubscriptionData(subscriptionData);
        subscription.setContextKey(this.getSubscriptionContextKey());
        subscription.setState(IncrementalSyncState.ACTIVE);
        return this.incrementalSyncSubscriptionManager.store(subscription);
    }

    protected String getSubscriptionContextKey() {
        return this.subscriptionContextKey;
    }

    protected String getKeyPrefix() {
        return "SERVER_";
    }

    @Override
    public Optional<IncrementalSyncSubscription> getSubscriptionStateData(MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier) {
        return this.incrementalSyncSubscriptionManager.getSubscription(subscriptionJournalIdentifier.getSubscriptionId().getValue()).filter(incrementalSyncSubscription -> incrementalSyncSubscription.getContextKey() != null && subscriptionJournalIdentifier.getJournalName().startsWith(incrementalSyncSubscription.getContextKey()));
    }

    @Override
    public boolean isSubscriptionActive(MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier) {
        Optional<IncrementalSyncSubscription> subscription = this.getSubscriptionStateData(subscriptionJournalIdentifier);
        return subscription.filter(incrementalSyncSubscription -> incrementalSyncSubscription.getState() == IncrementalSyncState.ACTIVE).isPresent();
    }
}

