/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentExpansions;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContentUpdateCommand
extends ContentManagementMultiEventsCommand<ContentEvent> {
    protected final ContentService contentService;
    protected final ObjectMapper objectMapper;

    public ContentUpdateCommand(ContentCommandSupport commandSupport, ContentService contentService) {
        super(commandSupport);
        this.contentService = contentService;
        this.objectMapper = new ObjectMapperProvider().getObjectMapper();
    }

    @Override
    protected Map<Class<? extends ContentEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(PageUpdateEvent.class, ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY, BlogPostUpdateEvent.class, ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY, CommentUpdateEvent.class, ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY, PageMoveEvent.class, ContentJournalEntryTypes.CONTENT_MOVED_ENTRY, BlogPostMovedEvent.class, ContentJournalEntryTypes.CONTENT_MOVED_ENTRY);
    }

    @Override
    protected List<JournalMessage> createMessages(ContentEvent event) {
        if (event instanceof PageUpdateEvent) {
            PageUpdateEvent pageUpdateEvent = (PageUpdateEvent)event;
            Page page = pageUpdateEvent.getPage();
            if (!Objects.equals(page.getContentStatus(), "draft")) {
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), page.getId(), ContentType.PAGE));
            }
        } else if (event instanceof BlogPostUpdateEvent) {
            BlogPostUpdateEvent blogPostUpdateEvent = (BlogPostUpdateEvent)event;
            BlogPost blogPost = blogPostUpdateEvent.getBlogPost();
            if (!Objects.equals(blogPost.getContentStatus(), "draft")) {
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), blogPost.getId(), ContentType.BLOG_POST));
            }
        } else {
            if (event instanceof CommentUpdateEvent) {
                CommentUpdateEvent commentUpdateEvent = (CommentUpdateEvent)event;
                Comment comment = commentUpdateEvent.getComment();
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), comment.getId(), ContentType.COMMENT));
            }
            if (event instanceof PageMoveEvent) {
                boolean parentChanged;
                PageMoveEvent pageMoveEvent = (PageMoveEvent)event;
                Page page = pageMoveEvent.getPage();
                boolean bl = parentChanged = !Objects.equals(pageMoveEvent.getOldParentPage(), pageMoveEvent.getPage().getParent());
                if (parentChanged) {
                    return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), page.getId(), ContentType.PAGE));
                }
            } else if (event instanceof BlogPostMovedEvent) {
                BlogPostMovedEvent blogPostMovedEvent = (BlogPostMovedEvent)event;
                BlogPost blogPost = blogPostMovedEvent.getBlogPost();
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), blogPost.getId(), ContentType.BLOG_POST));
            }
        }
        return Collections.emptyList();
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        Map<ContentId, JournalEntry> contentIdToJournalEntry = this.deserializeJournalMessage(journalEntries);
        PageResponse contentPageResponse = this.contentService.find(ContentExpansions.defaultExpansions()).withId(contentIdToJournalEntry.keySet()).fetchManyWithAnyType((PageRequest)new SimplePageRequest(LimitedRequestImpl.create((int)contentIdToJournalEntry.size())));
        return contentPageResponse.getResults().stream().map(content -> {
            JournalEntry journalEntry = (JournalEntry)contentIdToJournalEntry.get(content.getId());
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            Content updatedContent = !content.getAncestors().isEmpty() ? this.buildContentWithDirectAncestor((Content)content) : content;
            ContentModelType contentModelType = entryType == ContentJournalEntryTypes.CONTENT_MOVED_ENTRY ? ContentModelType.CONTENT_MANAGEMENT_CONTENT : ContentModelType.CONTENT_MANAGEMENT_BODY;
            return new ContentModel(journalEntry.getId(), contentModelType.getName(), entryType.getJsonModelOperation().getName(), updatedContent);
        }).toList();
    }

    private Map<ContentId, JournalEntry> deserializeJournalMessage(Collection<JournalEntry> journalEntries) {
        HashMap<ContentId, JournalEntry> contentIdToJournalEntry = new HashMap<ContentId, JournalEntry>();
        journalEntries.forEach(journalEntry -> {
            Optional<ContentJournalMessage> optionalContentJournalMessage = this.commandSupport.deserializeJournalMessage(ContentJournalMessage.class, (JournalEntry)journalEntry);
            if (optionalContentJournalMessage.isEmpty()) {
                this.logger.warn("Unable to deserialize journal message {}", journalEntry);
                return;
            }
            ContentJournalMessage journalMessage = optionalContentJournalMessage.get();
            contentIdToJournalEntry.put(ContentId.of((long)journalMessage.getContentId()), (JournalEntry)journalEntry);
        });
        return contentIdToJournalEntry;
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(ContentEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new ContentUpdateCommand(this.commandSupport, this.contentService)) : Optional.empty();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new ContentUpdateCommand(this.commandSupport, this.contentService));
    }
}

