/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentExpansions;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.pages.Attachment;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentUpdateCommand
implements Command<AttachmentUpdateEvent, ContentManagementIncSyncModel>,
CommandCreator<AttachmentUpdateEvent, ContentManagementIncSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentUpdateCommand.class);
    private final ContentCommandSupport commandSupport;
    private final ContentService contentService;

    public AttachmentUpdateCommand(ContentCommandSupport commandSupport, ContentService contentService) {
        this.commandSupport = commandSupport;
        this.contentService = contentService;
    }

    public void processEvent(AttachmentUpdateEvent event, Object ... params) {
        SubscriptionId subscriptionId = (SubscriptionId)params[0];
        SingleSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = new SingleSubscriptionPerJournalIdentifier("c_g_inc_sync", subscriptionId);
        Attachment attachment = event.getAttachment();
        ContentJournalMessage message = new ContentJournalMessage(Instant.now().toEpochMilli(), attachment.getId(), ContentType.ATTACHMENT);
        if (event.isAttachmentContainerUpdated()) {
            this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.CONTENT_MOVED_ENTRY), message);
            if (event.isMetadataChanged()) {
                this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY), message);
            }
        } else {
            this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY), message);
        }
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        Map<ContentId, JournalEntry> contentIdToJournalEntry = this.deserializeJournalMessage(journalEntries);
        PageResponse contentPageResponse = this.contentService.find(ContentExpansions.defaultExpansions()).withId(contentIdToJournalEntry.keySet()).fetchManyWithAnyType((PageRequest)new SimplePageRequest(LimitedRequestImpl.create((int)contentIdToJournalEntry.size())));
        return contentPageResponse.getResults().stream().map(content -> {
            JournalEntry journalEntry = (JournalEntry)contentIdToJournalEntry.get(content.getId());
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            return new ContentModel(journalEntry.getId(), ContentModelType.CONTENT_MANAGEMENT_CONTENT.getName(), entryType.getJsonModelOperation().getName(), (Content)content);
        }).toList();
    }

    public Optional<Command<AttachmentUpdateEvent, ContentManagementIncSyncModel>> newCommand(AttachmentUpdateEvent event) {
        return Optional.of(new AttachmentUpdateCommand(this.commandSupport, this.contentService));
    }

    public Optional<Command<AttachmentUpdateEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        if (!journalEntry.getType().equals(ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY.name()) && !journalEntry.getType().equals(ContentJournalEntryTypes.CONTENT_MOVED_ENTRY.name())) {
            return Optional.empty();
        }
        return Optional.of(new AttachmentUpdateCommand(this.commandSupport, this.contentService));
    }

    private Map<ContentId, JournalEntry> deserializeJournalMessage(Collection<JournalEntry> journalEntries) {
        HashMap<ContentId, JournalEntry> contentIdToJournalEntry = new HashMap<ContentId, JournalEntry>();
        journalEntries.forEach(journalEntry -> {
            Optional<ContentJournalMessage> optionalContentJournalMessage = this.commandSupport.deserializeJournalMessage(ContentJournalMessage.class, (JournalEntry)journalEntry);
            if (optionalContentJournalMessage.isEmpty()) {
                logger.warn("Unable to deserialize journal message {}", journalEntry);
                return;
            }
            ContentJournalMessage journalMessage = optionalContentJournalMessage.get();
            contentIdToJournalEntry.put(ContentId.of((long)journalMessage.getContentId()), (JournalEntry)journalEntry);
        });
        return contentIdToJournalEntry;
    }
}

