/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement;

import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.permission.ContentTreePermissionReindexEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionChangeEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionRemoveEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionSaveEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpaceLogoUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUnArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.AbstractRecorder;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.incrementalsync.model.CommandFactory;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.contentmanagement.ContentManagementIncrementalSyncService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class ContentManagementRecorder
extends AbstractRecorder {
    private final EventPublisher eventPublisher;
    private final ContentManagementIncrementalSyncService contentManagementIncrementalSyncService;

    public ContentManagementRecorder(CommandFactory<ContentManagementIncSyncModel> contentManagementCommandFactory, EventPublisher eventPublisher, TransactionTemplate transactionTemplate, ContentManagementIncrementalSyncService contentManagementIncrementalSyncService) {
        super(transactionTemplate, contentManagementCommandFactory);
        this.eventPublisher = eventPublisher;
        this.contentManagementIncrementalSyncService = contentManagementIncrementalSyncService;
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onContentPermissionEvent(ContentPermissionEvent contentPermissionEvent) {
        this.handleEvent(ContentEvent.class, contentPermissionEvent);
    }

    @EventListener
    public void onContentTreePermissionReindexEvent(ContentTreePermissionReindexEvent contentTreePermissionReindexEvent) {
        this.handleEvent(ContentEvent.class, contentTreePermissionReindexEvent);
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent pageCreateEvent) {
        this.handleEvent(ContentEvent.class, pageCreateEvent);
    }

    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent blogPostCreateEvent) {
        this.handleEvent(ContentEvent.class, blogPostCreateEvent);
    }

    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent commentCreateEvent) {
        this.handleEvent(ContentEvent.class, commentCreateEvent);
    }

    @EventListener
    public void onAttachmentCreateEvent(AttachmentCreateEvent attachmentCreateEvent) {
        this.handleEvent(ContentEvent.class, attachmentCreateEvent);
    }

    @EventListener
    public void onPageRemoveEvent(PageRemoveEvent pageRemoveEvent) {
        this.handleEvent(ContentEvent.class, pageRemoveEvent);
    }

    @EventListener
    public void onPageTrashedEvent(PageTrashedEvent pageTrashedEvent) {
        this.handleEvent(ContentEvent.class, pageTrashedEvent);
    }

    @EventListener
    public void onBlogPostRemoveEvent(BlogPostRemoveEvent blogPostRemoveEvent) {
        this.handleEvent(ContentEvent.class, blogPostRemoveEvent);
    }

    @EventListener
    public void onBlogPostTrashedEvent(BlogPostTrashedEvent blogPostTrashedEvent) {
        this.handleEvent(ContentEvent.class, blogPostTrashedEvent);
    }

    @EventListener
    public void onCommentRemoveEvent(CommentRemoveEvent commentRemoveEvent) {
        this.handleEvent(ContentEvent.class, commentRemoveEvent);
    }

    @EventListener
    public void onAttachmentRemoveEvent(AttachmentRemoveEvent attachmentRemoveEvent) {
        this.handleEvent(ContentEvent.class, attachmentRemoveEvent);
    }

    @EventListener
    public void onAttachmentTrashedEvent(AttachmentTrashedEvent attachmentTrashedEvent) {
        this.handleEvent(ContentEvent.class, attachmentTrashedEvent);
    }

    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent pageUpdateEvent) {
        this.handleEvent(ContentEvent.class, pageUpdateEvent);
    }

    @EventListener
    public void onBlogPostUpdateEvent(BlogPostUpdateEvent blogPostUpdateEvent) {
        this.handleEvent(ContentEvent.class, blogPostUpdateEvent);
    }

    @EventListener
    public void onCommentUpdateEvent(CommentUpdateEvent commentUpdateEvent) {
        this.handleEvent(ContentEvent.class, commentUpdateEvent);
    }

    @EventListener
    public void onSpaceCreateEvent(SpaceCreateEvent spaceCreateEvent) {
        this.handleEvent(SpaceEvent.class, spaceCreateEvent);
    }

    @EventListener
    public void onSpaceArchivedEvent(SpaceArchivedEvent spaceArchivedEvent) {
        this.handleEvent(SpaceEvent.class, spaceArchivedEvent);
    }

    @EventListener
    public void onSpaceUnArchivedEvent(SpaceUnArchivedEvent spaceUnArchivedEvent) {
        this.handleEvent(SpaceEvent.class, spaceUnArchivedEvent);
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent spaceRemoveEvent) {
        this.handleEvent(SpaceRemoveEvent.class, spaceRemoveEvent);
    }

    @EventListener
    public void onSpaceLogoUpdateEvent(SpaceLogoUpdateEvent spaceLogoUpdateEvent) {
        this.handleEvent(SpaceEvent.class, spaceLogoUpdateEvent);
    }

    @EventListener
    public void onSpaceUpdateEvent(SpaceUpdateEvent spaceUpdateEvent) {
        this.handleEvent(SpaceEvent.class, spaceUpdateEvent);
    }

    @EventListener
    public void onPageRestoreEvent(PageRestoreEvent pageRestoreEvent) {
        this.handleEvent(ContentEvent.class, pageRestoreEvent);
    }

    @EventListener
    public void onBlogPostRestoreEvent(BlogPostRestoreEvent blogPostRestoreEvent) {
        this.handleEvent(ContentEvent.class, blogPostRestoreEvent);
    }

    @EventListener
    public void onAttachmentRestoreEvent(GeneralAttachmentRestoreEvent attachmentRestoreEvent) {
        this.handleEvent(ContentEvent.class, attachmentRestoreEvent);
    }

    @EventListener
    public void onSpacePermissionSaveEvent(SpacePermissionSaveEvent spacePermissionSaveEvent) {
        this.handleEvent(SpacePermissionChangeEvent.class, spacePermissionSaveEvent);
    }

    @EventListener
    public void onSpacePermissionRemoveEvent(SpacePermissionRemoveEvent spacePermissionRemoveEvent) {
        this.handleEvent(SpacePermissionChangeEvent.class, spacePermissionRemoveEvent);
    }

    @EventListener
    public void onAsyncImportFinishedEvent(AsyncImportFinishedEvent asyncImportFinishedEvent) {
        this.handleEvent(AsyncImportFinishedEvent.class, asyncImportFinishedEvent);
    }

    @EventListener
    public void onPageMoveEvent(PageMoveEvent pageMoveEvent) {
        this.handleEvent(ContentEvent.class, pageMoveEvent);
    }

    @EventListener
    public void onBlogPostMoveEvent(BlogPostMovedEvent blogPostMovedEvent) {
        this.handleEvent(ContentEvent.class, blogPostMovedEvent);
    }

    @EventListener
    public void onAttachmentUpdateEvent(AttachmentUpdateEvent attachmentUpdateEvent) {
        this.handleEvent(AttachmentUpdateEvent.class, attachmentUpdateEvent);
    }

    @Override
    protected <T> void executeCommand(CommandFactory<?> commandFactory, Class<?> eventClass, T event) {
        this.contentManagementIncrementalSyncService.handleEventForSubscription(event, journalIdentifier -> {
            MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)((Object)journalIdentifier);
            commandFactory.createCommand(eventClass, event).ifPresent(command -> command.processEvent(event, new Object[]{subscriptionJournalIdentifier.getSubscriptionId()}));
        });
    }

    protected ContentManagementIncrementalSyncService getIncrementalSyncService() {
        return this.contentManagementIncrementalSyncService;
    }
}

