/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.permission.ContentTreePermissionReindexEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionChangeEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceLogoUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUnArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.impl.journal.JournalServiceInternal;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.AbstractIncrementalSyncService;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.IncrementalSyncDataFetcher;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SubscriptionJournalStateStore;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.IncrementalSyncUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionEventType;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentSubscriptionSpec;
import com.atlassian.confluence.internal.api.service.incrementalsync.contentmanagement.ContentManagementIncrementalSyncService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.core.util.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ContentManagementIncrementalSyncServiceImpl
extends AbstractIncrementalSyncService<ContentSubscriptionSpec, ContentManagementIncSyncModel>
implements ContentManagementIncrementalSyncService {
    public static final String CONTENT_MANAGEMENT_INC_SYNC_JOURNAL_NAME = "c_g_inc_sync";
    private final Map<Class<?>, SubscriptionEventType> eventClassToEventType = Map.ofEntries(Map.entry(AttachmentEvent.class, SubscriptionEventType.ATTACHMENT_EVENT), Map.entry(AsyncImportFinishedEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(BlogPostEvent.class, SubscriptionEventType.BLOGPOST_EVENT), Map.entry(CommentEvent.class, SubscriptionEventType.COMMENT_EVENT), Map.entry(PageEvent.class, SubscriptionEventType.PAGE_EVENT), Map.entry(SpaceRemoveEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpaceCreateEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpaceArchivedEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpaceUnArchivedEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpaceLogoUpdateEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpacePermissionChangeEvent.class, SubscriptionEventType.SPACE_EVENT), Map.entry(SpaceUpdateEvent.class, SubscriptionEventType.SPACE_EVENT));

    public ContentManagementIncrementalSyncServiceImpl(JournalServiceInternal journalService, SubscriptionJournalStateStore subscriptionJournalStateStore, Clock clock, PermissionManager permissionManager, IncrementalSyncDataFetcher<ContentManagementIncSyncModel> incrementalSyncDataFetcher, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        super(journalService, subscriptionJournalStateStore, clock, permissionManager, incrementalSyncDataFetcher, scopesRequestCacheDelegate);
    }

    @Override
    public SubscriptionId subscribe(ContentSubscriptionSpec spec) {
        this.verifyAdminUserOrManageSubscriptionScope();
        return this.subscriptionJournalStateStore.createNewSubscription(this.getSubscriptionData(spec));
    }

    @Override
    protected String getSubscriptionData(ContentSubscriptionSpec spec) {
        return spec.getSupportedContentEventTypeString();
    }

    @Override
    protected String getJournalName() {
        return CONTENT_MANAGEMENT_INC_SYNC_JOURNAL_NAME;
    }

    @Override
    protected SingleSubscriptionPerJournalIdentifier getJournalIdentifier(long subscriptionId) {
        return new SingleSubscriptionPerJournalIdentifier(CONTENT_MANAGEMENT_INC_SYNC_JOURNAL_NAME, SubscriptionId.of((long)subscriptionId));
    }

    private List<SingleSubscriptionPerJournalIdentifier> getAllSubscriptionIdentifiers() {
        return Stream.concat(this.subscriptionJournalStateStore.getAvailableSubscriptions().stream(), this.subscriptionJournalStateStore.getDeactivateSubscriptions().stream()).map(id -> new SingleSubscriptionPerJournalIdentifier(CONTENT_MANAGEMENT_INC_SYNC_JOURNAL_NAME, (SubscriptionId)id)).toList();
    }

    private List<SingleSubscriptionPerJournalIdentifier> getActiveSubscriptionIdentifiers() {
        return this.subscriptionJournalStateStore.getAvailableSubscriptions().stream().map(id -> new SingleSubscriptionPerJournalIdentifier(CONTENT_MANAGEMENT_INC_SYNC_JOURNAL_NAME, (SubscriptionId)id)).toList();
    }

    public Collection<? extends JournalIdentifier> getManagedJournalIdentifier() {
        return this.getAllSubscriptionIdentifiers();
    }

    @Override
    public <E> void handleEventForSubscription(E event, Consumer<JournalIdentifier> processor) {
        for (MultiSubscriptionPerJournalIdentifier multiSubscriptionPerJournalIdentifier : this.getActiveSubscriptionIdentifiers()) {
            this.subscriptionJournalStateStore.getSubscriptionStateData(multiSubscriptionPerJournalIdentifier).map(incrementalSyncSubscription -> IncrementalSyncUtil.convertStringToEnumList(incrementalSyncSubscription.getSubscriptionData())).ifPresent(subscriptionEventTypes -> {
                for (Map.Entry<Class<?>, SubscriptionEventType> entry : this.eventClassToEventType.entrySet()) {
                    Class<?> key = entry.getKey();
                    SubscriptionEventType value = entry.getValue();
                    if (!key.isInstance(event) || !subscriptionEventTypes.contains(value)) continue;
                    this.logger.debug("Found subscription {} which handle event {}", (Object)subscriptionIdentifier.getSubscriptionId(), event);
                    processor.accept(subscriptionIdentifier);
                }
                if (event instanceof ContentPermissionEvent || event instanceof ContentTreePermissionReindexEvent) {
                    this.handleContentPermissionEvents((Object)event, (List<SubscriptionEventType>)subscriptionEventTypes, processor, subscriptionIdentifier);
                }
            });
        }
    }

    public int getEventsBatchLimit() {
        return Integer.getInteger("confluence.incremental.sync.events.batch.limit.content", 100);
    }

    private <T> void handleContentPermissionEvents(T event, List<SubscriptionEventType> subscriptionEventTypes, Consumer<JournalIdentifier> processor, MultiSubscriptionPerJournalIdentifier subscriptionIdentifier) {
        String contentType;
        if (event instanceof ContentPermissionEvent) {
            ContentPermissionEvent contentPermissionEvent = (ContentPermissionEvent)event;
            contentType = contentPermissionEvent.getContent().getType();
        } else {
            contentType = ((ContentTreePermissionReindexEvent)event).getContent().getType();
        }
        String eventType = contentType.trim().toUpperCase() + "_EVENT";
        try {
            SubscriptionEventType subscriptionEventType = SubscriptionEventType.valueOf((String)eventType);
            if (subscriptionEventTypes.contains(subscriptionEventType)) {
                this.logger.debug("Found subscription {} which handles {} permission event {}", new Object[]{subscriptionIdentifier.getSubscriptionId(), eventType, event});
                processor.accept(subscriptionIdentifier);
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("No enum constant for event type: {}", (Object)eventType);
        }
    }
}

