/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.impl.journal.JournalServiceInternal;
import com.atlassian.confluence.impl.transaction.ReadOnlyAndReadWriteTransactionConversionTemplate;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.IncrementalSyncDataFetcher;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.IncrementalSynchronisationNotAvailable;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.incrementalsync.model.CommandFactory;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class IncrementalSyncDataFetcherImpl<T extends IncrementalSyncModel>
implements IncrementalSyncDataFetcher<T> {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalSyncDataFetcherImpl.class);
    private final PlatformTransactionManager transactionManager;
    private final PaginationService paginationService;
    private final JournalServiceInternal journalService;
    private final CommandFactory<T> commandFactory;
    private final String journalName;
    private final boolean singleSubscription;

    public IncrementalSyncDataFetcherImpl(PlatformTransactionManager transactionManager, PaginationService paginationService, JournalServiceInternal journalService, CommandFactory<T> commandFactory, String journalName, boolean singleSubscription) {
        this.transactionManager = transactionManager;
        this.paginationService = paginationService;
        this.journalService = journalService;
        this.commandFactory = commandFactory;
        this.journalName = journalName;
        this.singleSubscription = singleSubscription;
    }

    @Override
    public PageResponse<T> getEvents(PageRequest pageRequest) {
        Cursor cursor;
        if (pageRequest.getCursor() == null || !((cursor = pageRequest.getCursor()) instanceof IncrementalSyncCursor)) {
            throw new BadRequestException("Cursor must be an instance of IncrementalSyncCursor");
        }
        IncrementalSyncCursor cursor2 = (IncrementalSyncCursor)cursor;
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)pageRequest.getLimit());
        return this.paginationService.performPaginationListRequestWithCursor(limitedRequest, this::fetchBatch, m -> m, (lastRecord, isReverse) -> this.cursorCalculator(cursor2, lastRecord));
    }

    private PageResponse<T> fetchBatch(LimitedRequest request) {
        Cursor cursor;
        if (request.getCursor() == null || !((cursor = request.getCursor()) instanceof IncrementalSyncCursor)) {
            throw new IllegalArgumentException("Cursor must be an instance of IncrementalSyncCursor");
        }
        IncrementalSyncCursor cursor2 = (IncrementalSyncCursor)cursor;
        ReadOnlyAndReadWriteTransactionConversionTemplate template = new ReadOnlyAndReadWriteTransactionConversionTemplate(this.transactionManager);
        return (PageResponse)template.executeInReadWrite(() -> {
            JournalIdentifier journalIdentifier = this.createJournalIdentifier(cursor2);
            return (PageResponse)this.journalService.processNewEntries(journalIdentifier, request.getLimit(), journalEntries -> {
                Object pageResponse;
                List<JournalEntry> journalEntriesList = StreamSupport.stream(journalEntries.spliterator(), false).toList();
                List<T> incrementalSyncRecords = this.processJournalEntries(journalEntriesList);
                ArrayList<IncrementalSyncModel> failedEntity = new ArrayList<IncrementalSyncModel>();
                for (IncrementalSyncModel incrementalSyncRecord : incrementalSyncRecords) {
                    if (!(incrementalSyncRecord instanceof IncrementalSynchronisationNotAvailable)) continue;
                    failedEntity.add(incrementalSyncRecord);
                    break;
                }
                if (!failedEntity.isEmpty()) {
                    pageResponse = this.prepareIntermediatePageResponse(journalEntriesList, failedEntity, request, cursor2, false);
                    return EntryProcessorResult.success(pageResponse);
                }
                pageResponse = this.prepareIntermediatePageResponse(journalEntriesList, incrementalSyncRecords, request, cursor2, true);
                return EntryProcessorResult.success(pageResponse);
            });
        });
    }

    private JournalIdentifier createJournalIdentifier(IncrementalSyncCursor cursor) {
        SubscriptionId subscriptionId = SubscriptionId.of((IncrementalSyncCursor)cursor);
        if (this.singleSubscription) {
            return new SingleSubscriptionPerJournalIdentifier(this.journalName, subscriptionId, subscriptionId.getMostRecentId());
        }
        return new MultiSubscriptionPerJournalIdentifier(this.journalName, subscriptionId, subscriptionId.getMostRecentId());
    }

    private List<T> processJournalEntries(List<JournalEntry> batch) {
        ArrayList<IncrementalSyncModel> processedEntries = new ArrayList<IncrementalSyncModel>();
        batch.stream().collect(Collectors.groupingBy(JournalEntry::getType)).forEach((journalEntryType, journalEntries) -> processedEntries.addAll(this.processEntriesOfSameType((List<JournalEntry>)journalEntries)));
        processedEntries.sort(Comparator.comparing(IncrementalSyncModel::getJournalEntryId));
        return processedEntries;
    }

    private Collection<T> processEntriesOfSameType(List<JournalEntry> entries) {
        JournalEntry firstEntry = entries.get(0);
        try {
            Optional commandOptional = this.commandFactory.createCommand(firstEntry);
            if (commandOptional.isEmpty()) {
                logger.warn("Could not find corresponding command for type {} we will skip this batch", (Object)firstEntry.getType());
                return Collections.emptyList();
            }
            Collection modelCollection = ((Command)commandOptional.get()).processJournalEntries(entries);
            if (modelCollection != null) {
                return modelCollection;
            }
            logger.warn("Command return null result for processing journal entry. Command class is {}", (Object)((Command)commandOptional.get()).getClass().getName());
        }
        catch (Exception e) {
            logger.warn("Could not process journal entries for type {}", (Object)firstEntry.getType(), (Object)e);
        }
        return Collections.emptyList();
    }

    private PageResponse<T> prepareIntermediatePageResponse(List<JournalEntry> initialJournalEntries, List<T> processedEntries, LimitedRequest pageRequest, IncrementalSyncCursor currentCursor, boolean isIncrementalSyncAvailable) {
        boolean hasMore = isIncrementalSyncAvailable && initialJournalEntries.size() >= pageRequest.getLimit();
        IncrementalSyncCursor nextCursor = isIncrementalSyncAvailable ? (IncrementalSyncCursor)this.getMaxId(initialJournalEntries).map(m -> new IncrementalSyncCursor(currentCursor.getSubscriptionId(), m.longValue())).orElse(null) : (IncrementalSyncCursor)this.journalService.getMostRecentId(this.createJournalIdentifier(currentCursor)).map(m -> new IncrementalSyncCursor(currentCursor.getSubscriptionId(), m.getId())).orElse(null);
        return PageResponseImpl.from(processedEntries, (boolean)hasMore).nextCursor((Cursor)nextCursor).pageRequest(pageRequest).build();
    }

    private Optional<Long> getMaxId(List<JournalEntry> journalEntries) {
        return journalEntries.stream().map(JournalEntry::getId).max(Comparator.comparingLong(s -> s));
    }

    private IncrementalSyncCursor cursorCalculator(IncrementalSyncCursor originalCursor, T lastRecord) {
        return new IncrementalSyncCursor(originalCursor.getSubscriptionId(), lastRecord.getJournalEntryId());
    }
}

