/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.instance;

import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.instance.InstanceMetricsServiceValidator;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;

public final class InstanceMetricsServiceValidatorImpl
implements InstanceMetricsServiceValidator {
    private final PermissionManager permissionManager;

    public InstanceMetricsServiceValidatorImpl(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public ValidationResult validateGetInstanceMetrics() {
        if (AuthenticatedUserThreadLocal.isAnonymousUser()) {
            return SimpleValidationResult.FORBIDDEN;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return SimpleValidationResult.FORBIDDEN;
        }
        return SimpleValidationResult.VALID;
    }
}

