/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.instance;

import com.atlassian.confluence.api.model.InstanceMetrics;
import com.atlassian.confluence.api.service.instance.InstanceMetricsService;
import com.atlassian.confluence.api.service.instance.InstanceMetricsServiceValidator;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;

public final class InstanceMetricsServiceImpl
implements InstanceMetricsService {
    private final SystemInformationService systemInformationService;
    private final InstanceMetricsServiceValidator validator;

    public InstanceMetricsServiceImpl(SystemInformationService systemInformationService, InstanceMetricsServiceValidator validator) {
        this.systemInformationService = systemInformationService;
        this.validator = validator;
    }

    public InstanceMetrics getInstanceMetrics() {
        this.validator.validateGetInstanceMetrics().throwIfNotSuccessful();
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        return this.buildInstanceMetrics(usageInfo);
    }

    private InstanceMetrics buildInstanceMetrics(UsageInfo usageInfo) {
        return new InstanceMetrics(usageInfo.getAllContent(), usageInfo.getTotalSpaces(), usageInfo.getLocalUsers());
    }
}

