/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.typebinding;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.content.apisupport.ApiSupportProvider;
import com.atlassian.confluence.content.apisupport.BaseContentTypeApiSupport;
import com.atlassian.confluence.content.apisupport.ContentCreator;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentConvertible;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.time.OffsetDateTime;
import java.util.Date;

public class BlogPostContentTypeApiSupport
extends BaseContentTypeApiSupport<BlogPost> {
    private final ContentCreator contentCreator;

    public BlogPostContentTypeApiSupport(ApiSupportProvider provider, ContentCreator contentCreator) {
        super(provider);
        this.contentCreator = contentCreator;
    }

    public ContentType getHandledType() {
        return ContentType.BLOG_POST;
    }

    protected PageResponse<Content> getChildrenForThisType(BlogPost content, LimitedRequest limitedRequest, Expansions expansions, Depth depth) {
        return PageResponseImpl.empty((boolean)false);
    }

    public boolean supportsChildrenOfType(ContentType otherType) {
        return !otherType.equals((Object)ContentType.PAGE);
    }

    protected PageResponse<Content> getChildrenOfThisTypeForOtherType(ContentConvertible otherTypeParent, LimitedRequest limitedRequest, Expansions expansions, Depth depth) {
        return PageResponseImpl.empty((boolean)false);
    }

    public boolean supportsChildrenForParentType(ContentType parentType) {
        return false;
    }

    public Class<BlogPost> getEntityClass() {
        return BlogPost.class;
    }

    public ValidationResult validateCreate(Content newContent) {
        return this.contentCreator.validateCreate(AuthenticatedUserThreadLocal.get(), newContent, this.getEntityClass());
    }

    public ValidationResult validateUpdate(Content updatedContent, BlogPost existingEntity) {
        return this.contentCreator.validateUpdate(AuthenticatedUserThreadLocal.get(), updatedContent, (ContentEntityObject)existingEntity);
    }

    public BlogPost create(Content newContent) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        BlogPost blog = new BlogPost();
        this.contentCreator.setCommonPropertiesForCreate(newContent, (ContentEntityObject)blog, (User)user);
        this.setCreationDate(newContent, blog);
        Draft draft = (Draft)newContent.getExtension("draft");
        return (BlogPost)this.contentCreator.saveNewContent((ContentEntityObject)blog, newContent.getVersion(), draft);
    }

    private void setCreationDate(Content newContent, BlogPost blog) {
        History history;
        OffsetDateTime publishDate;
        Reference historyRef = newContent.getHistoryRef();
        if (historyRef.isExpanded() && historyRef.exists() && (publishDate = (history = (History)newContent.getHistoryRef().get()).getCreatedAt()) != null) {
            blog.setCreationDate(Date.from(publishDate.toInstant()));
        }
    }

    public BlogPost update(Content updatedContent, BlogPost blog) {
        boolean isNewBlog;
        BlogPost originalBlog = (BlogPost)this.contentCreator.cloneForUpdate((ContentEntityObject)blog);
        boolean blogPropertiesChanged = this.contentCreator.setCommonPropertiesForUpdate(updatedContent, (ContentEntityObject)blog);
        boolean blogMetadataChanged = this.contentCreator.setCommonMetadata(updatedContent, (ContentEntityObject)blog);
        boolean bl = isNewBlog = originalBlog.getOriginalVersionId() == null && originalBlog.getContentStatusObject() == ContentStatus.DRAFT;
        if (isNewBlog) {
            this.setCreationDate(updatedContent, blog);
        }
        boolean changed = blogPropertiesChanged;
        if (changed |= blogMetadataChanged) {
            return (BlogPost)this.contentCreator.update((ContentEntityObject)blog, (ContentEntityObject)originalBlog, updatedContent.getVersion());
        }
        return blog;
    }
}

