/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractPageAndBlogFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderImpl;
import com.atlassian.confluence.api.impl.service.content.finder.ContentLocatorFetcher;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;

public class BlogPostFetcher
extends AbstractPageAndBlogFetcher {
    public BlogPostFetcher(ContentFinderImpl contentFinder, PaginationService paginationService, PageManagerInternal pageManagerInternal, ContentFactory contentFactory, SpaceManager spaceManager, PermissionManager permissionManager) {
        super(contentFinder, paginationService, pageManagerInternal, contentFactory, spaceManager, permissionManager);
    }

    @Override
    public PageResponse<Content> fetch(LimitedRequest request) throws BadRequestException {
        if (this.contentFinder.getContentContainerId() != null) {
            return PageResponseImpl.empty((boolean)false, (LimitedRequest)request);
        }
        if (this.contentFinder.getCreatedDate() != null && this.contentFinder.getSpaces().size() == 1 && this.contentFinder.getTitle() != null) {
            return this.fetchBlogPostBySpaceAndTitleAndDate(request);
        }
        if (this.contentFinder.getTitle() != null) {
            return this.fetchByTitle(ContentType.BLOG_POST, request);
        }
        if (this.contentFinder.getCreatedDate() != null) {
            return this.fetchByDate(ContentType.BLOG_POST, request);
        }
        if (this.contentFinder.getSpaces().size() == 1) {
            return this.fetchBySpace(ContentType.BLOG_POST, request);
        }
        return this.fetchAllContent(ContentType.BLOG_POST, request);
    }

    @Override
    protected void validateCursor(LimitedRequest request) {
        CursorType requestedCursorType = request.getCursor().getCursorType();
        if (requestedCursorType != CursorType.BLOG_POST) {
            throw new IllegalArgumentException(String.format("Cursor type is incorrect. Received: %s, but %s was expected", request.getCursor().getCursorType(), CursorType.BLOG_POST));
        }
    }

    @Override
    protected void validateContentType(ContentType contentType) {
        if (!contentType.equals((Object)ContentType.BLOG_POST)) {
            throw new IllegalArgumentException(String.format("Content type %s is not supported in cursor pagination requests", contentType));
        }
    }

    private PageResponse<Content> fetchBlogPostBySpaceAndTitleAndDate(LimitedRequest request) {
        Space space = this.spaceManager.getSpace(this.contentFinder.getSpaces().get(0).getKey());
        if (space == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        ContentLocator locator = ContentLocator.builder().forBlog().bySpaceKeyTitleAndPostingDay(space.getKey(), this.contentFinder.getTitle(), this.contentFinder.getCreatedDate());
        Content blog = (Content)new ContentLocatorFetcher(locator, this.contentFactory, this.pageManager, this.contentFinder.expansions).fetchOrNull();
        return blog != null && blog.getId() != null && this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)this.pageManager.getAbstractPage(blog.getId().asLong())) ? PageResponseImpl.fromSingle((Object)blog, (boolean)false).pageRequest(request).build() : PageResponseImpl.empty((boolean)false, (LimitedRequest)request);
    }
}

