/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderImpl;
import com.atlassian.confluence.api.impl.service.content.typebinding.AttachmentContentTypeApiSupport;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.AttachmentManagerInternal;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class AttachmentFetcher
implements ContentFetcher {
    private final ContentFinderImpl contentFinder;
    private final PaginationService paginationService;
    private final ContentFactory contentFactory;
    private final SpaceManager spaceManager;
    private final AttachmentManagerInternal attachmentManager;
    private final AttachmentContentTypeApiSupport attachmentContentTypeApiSupport;

    public AttachmentFetcher(ContentFinderImpl contentFinder, PaginationService paginationService, ContentFactory contentFactory, SpaceManager spaceManager, AttachmentManagerInternal attachmentManager, AttachmentContentTypeApiSupport attachmentContentTypeApiSupport) {
        this.contentFinder = contentFinder;
        this.paginationService = paginationService;
        this.contentFactory = contentFactory;
        this.spaceManager = spaceManager;
        this.attachmentManager = attachmentManager;
        this.attachmentContentTypeApiSupport = attachmentContentTypeApiSupport;
    }

    @Override
    public PageResponse<Content> fetch(LimitedRequest request) throws BadRequestException {
        if (this.contentFinder.getContentContainerId() != null) {
            return this.attachmentContentTypeApiSupport.getAttachments(this.contentFinder.getContentContainerId(), request, (com.google.common.base.Predicate<? super Attachment>)((com.google.common.base.Predicate)this.contentFinder.asPredicate()::test), this.contentFinder.getExpansions());
        }
        if (this.contentFinder.getSpaces().size() == 1) {
            return this.fetchBySpace(request);
        }
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.attachmentManager.countAttachmentsByStatuses(this.contentFinder.getStatuses()));
        PageResponse<Content> pageResponse = this.fetchAllContent(request);
        return PageResponseImpl.from(pageResponse, totalContentCount);
    }

    private PageResponse<Content> fetchBySpace(LimitedRequest request) {
        Space space = this.spaceManager.getSpace(this.contentFinder.getSpaces().get(0).getKey());
        if (space == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        if (request.getCursor() == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.attachmentManager.countAttachmentsBySpaceAndStatuses(space, this.contentFinder.getStatuses()));
        PageResponse<Content> pageResponse = this.fetchBySpaceWithCursor(request, space);
        return PageResponseImpl.from(pageResponse, totalContentCount);
    }

    private PageResponse<Content> fetchBySpaceWithCursor(LimitedRequest request, Space space) {
        return this.doPaginationRequestWithCursor(request, limitedRequest -> this.attachmentManager.scanFilteredAttachments(space, this.contentFinder.getStatuses(), limitedRequest, new Predicate[0]), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> doPaginationRequestWithCursor(LimitedRequest request, Function<LimitedRequest, PageResponse<Attachment>> visibleContentScanner, Expansions expansions) {
        this.validateCursor(request);
        return this.paginationService.performPaginationListRequestWithCursor(request, visibleContentScanner, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions), AttachmentFetcher::calculateCursorFromContent);
    }

    private PageResponse<Content> doPaginationRequest(LimitedRequest request, PaginationBatch<? extends Attachment> paginationBatch, Expansions expansions) {
        return this.paginationService.performPaginationListRequest(request, paginationBatch, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions));
    }

    private PageResponse<Content> fetchAllContent(LimitedRequest request) {
        if (request.getCursor() == null) {
            return this.fetchAllContentWithOffset(request);
        }
        return this.fetchAllContentWithCursor(request);
    }

    private void validateCursor(LimitedRequest request) {
        CursorType requestedCursorType = request.getCursor().getCursorType();
        if (!requestedCursorType.equals((Object)CursorType.ATTACHMENT)) {
            throw new IllegalArgumentException(String.format("Cursor type is incorrect. Received: %s, but %s was expected", request.getCursor().getCursorType(), CursorType.ATTACHMENT.getType()));
        }
    }

    private PageResponse<Content> fetchAllContentWithCursor(LimitedRequest request) {
        return this.doPaginationRequestWithCursor(request, limitedRequest -> this.attachmentManager.scanFilteredAttachments(this.contentFinder.getStatuses(), limitedRequest, new Predicate[0]), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> fetchAllContentWithOffset(LimitedRequest request) {
        return this.doPaginationRequest(request, (PaginationBatch<? extends Attachment>)((PaginationBatch)limitedRequest -> this.attachmentManager.scanFilteredAttachments(this.contentFinder.getStatuses(), limitedRequest, new Predicate[0])), this.contentFinder.getExpansions());
    }

    private static ContentCursor calculateCursorFromContent(Attachment content, boolean isReverse) {
        return ContentCursor.createCursor((boolean)isReverse, (long)content.getId(), (CursorType)CursorType.ATTACHMENT);
    }
}

