/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.factory;

import com.atlassian.confluence.api.impl.service.content.factory.ChildContentFactory;
import com.atlassian.confluence.api.impl.service.content.factory.ContentBodyFactory;
import com.atlassian.confluence.api.impl.service.content.factory.ContentExtensionsFactory;
import com.atlassian.confluence.api.impl.service.content.factory.ContentMetadataFactory;
import com.atlassian.confluence.api.impl.service.content.factory.Fauxpansions;
import com.atlassian.confluence.api.impl.service.content.factory.HistoryFactory;
import com.atlassian.confluence.api.impl.service.content.factory.SpaceFactory;
import com.atlassian.confluence.api.impl.service.content.factory.VersionFactory;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.ModelFactory;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.content.Position;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationCheckResult;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.RelevantViewRestrictions;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.api.service.permissions.OperationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Contained;
import com.atlassian.confluence.pages.ContentConvertible;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFactory
implements ModelFactory<ContentEntityObject, Content> {
    private static final Logger logger = LoggerFactory.getLogger(ContentFactory.class);
    private static final String EXTENSIONS = "extensions";
    private static final String MAX_SUPPORTED_NESTED_LEVELS_PROP = "confluence.comment.relevant.permission.max.nested.levels";
    private static final int maxSupportedNestedLevel = Integer.getInteger("confluence.comment.relevant.permission.max.nested.levels", 100);
    private final ContentBodyFactory contentBodyFactory;
    private final SpaceFactory spaceFactory;
    private final ContentMetadataFactory metadataFactory;
    private final VersionFactory versionFactory;
    private final HistoryFactory historyFactory;
    private final ChildContentFactory childContentFactory;
    private final ContentExtensionsFactory extensionsFactory;
    private final OperationService operationService;
    private final ContentRestrictionService contentRestrictionService;
    private final NavigationService navigationService;

    public ContentFactory(ContentBodyFactory contentBodyFactory, SpaceFactory spaceFactory, ContentMetadataFactory metadataFactory, VersionFactory versionFactory, HistoryFactory historyFactory, ChildContentFactory childContentFactory, ContentExtensionsFactory extensionsFactory, OperationService operationService, ContentRestrictionService contentRestrictionService, NavigationService navigationService) {
        this.contentBodyFactory = contentBodyFactory;
        this.spaceFactory = spaceFactory;
        this.metadataFactory = metadataFactory;
        this.versionFactory = versionFactory;
        this.historyFactory = historyFactory;
        this.childContentFactory = childContentFactory;
        this.extensionsFactory = extensionsFactory;
        this.operationService = operationService;
        this.contentRestrictionService = contentRestrictionService;
        this.navigationService = navigationService;
    }

    public Content buildFrom(ContentEntityObject entity, Expansions expansions) {
        return this.buildFrom(() -> new SingletonIterator((Object)entity), expansions).iterator().next();
    }

    public Iterable<Content> buildFrom(Iterable<? extends ContentEntityObject> entities, Expansions expansions) {
        Map<ContentEntityObject, Content.ContentBuilder> builders = this.buildersFrom(entities, expansions);
        ImmutableList.Builder results = ImmutableList.builder();
        for (ContentEntityObject contentEntityObject : entities) {
            results.add((Object)builders.get(contentEntityObject).build());
        }
        return results.build();
    }

    public Reference<Content> buildRef(ContentEntityObject entity, Fauxpansions fauxpansions) {
        if (!fauxpansions.canExpand()) {
            if (entity == null) {
                return Reference.collapsed(Content.class);
            }
            return Content.buildReference((ContentSelector)entity.getSelector());
        }
        if (entity == null) {
            return Reference.empty(Content.class);
        }
        return Reference.to((Object)this.buildFrom(entity, fauxpansions.getSubExpansions()));
    }

    public Content.ContentBuilder builderFrom(ContentEntityObject entity, ContentType contentType, Expansions expansions) {
        return (Content.ContentBuilder)Iterables.first(this.buildersFrom((Iterable<? extends ContentEntityObject>)Option.some((Object)entity), expansions).values()).get();
    }

    private Map<ContentEntityObject, Content.ContentBuilder> buildersFrom(Iterable<? extends ContentEntityObject> entities, Expansions expansions) {
        HashMap<ContentEntityObject, Content.ContentBuilder> map = new HashMap<ContentEntityObject, Content.ContentBuilder>();
        Optional<Map<ContentId, RelevantViewRestrictions>> contentRelevantViewRestrictionsOptional = Optional.empty();
        if (expansions.canExpand("relevantViewRestrictions")) {
            contentRelevantViewRestrictionsOptional = this.getRelevantViewRestrictionsMap(entities, expansions);
        }
        for (ContentEntityObject contentEntityObject : entities) {
            if (map.containsKey(contentEntityObject)) continue;
            if (!(contentEntityObject instanceof ContentConvertible) || !((ContentConvertible)contentEntityObject).shouldConvertToContent()) {
                throw new BadRequestException("The entity " + String.valueOf(contentEntityObject) + " is not ContentConvertible or API available");
            }
            ContentType contentType = ((ContentConvertible)contentEntityObject).getContentTypeObject();
            Content.ContentBuilder builder = Content.builder((ContentType)contentType);
            builder.ancestors(this.makeAncestry((Versioned)contentEntityObject, expansions));
            builder.body(this.makeContentBodies(contentEntityObject, expansions));
            this.addCommonFieldsToBuilder(builder, contentEntityObject, expansions);
            Optional<RelevantViewRestrictions> relevantViewRestrictions = this.getRelevantViewRestrictionsForContent(contentRelevantViewRestrictionsOptional, contentEntityObject, expansions);
            if (relevantViewRestrictions.isPresent()) {
                builder.relevantViewRestrictionsReference(Reference.to((Object)relevantViewRestrictions.get()));
            } else {
                builder.relevantViewRestrictionsReference(RelevantViewRestrictions.buildReference((Navigation.Builder)this.navigationService.createNavigation().content(contentEntityObject.getSelector()).relevantViewRestrictions()));
            }
            map.put(contentEntityObject, builder);
        }
        this.addCommonFieldsToBuilders(map, expansions);
        return map;
    }

    private Optional<Map<ContentId, RelevantViewRestrictions>> getRelevantViewRestrictionsMap(Iterable<? extends ContentEntityObject> entities, Expansions expansions) {
        Map<Long, Long> contentIdToParentIdMap;
        Multimap<ContentEntityObject, ContentEntityObject> containerToContentMap = this.makeContainerToContentMap(entities);
        Multimap<ContentId, ContentId> containerIdToContentIdMap = this.mapContainerIdToContentIdMap(containerToContentMap);
        LimitedRequest limitedRequest = LimitedRequestImpl.create((int)0, (int)PaginationLimits.relevantViewRestrictionsExpansion(), (int)PaginationLimits.relevantViewRestrictionsExpansion());
        Optional<Map<ContentId, RelevantViewRestrictions>> contentRelevantViewRestrictionsOptional = Optional.ofNullable(this.contentRestrictionService.getRelevantViewRestrictionsForContent(limitedRequest, contentIdToParentIdMap = containerToContentMap.keySet().stream().collect(Collectors.toMap(EntityObject::getId, entity -> {
            if (entity instanceof Page && ((Page)entity).getParent() != null) {
                return ((Page)entity).getParent().getId();
            }
            return 0L;
        })), expansions));
        if (contentRelevantViewRestrictionsOptional.isEmpty()) {
            return contentRelevantViewRestrictionsOptional;
        }
        Map<ContentId, RelevantViewRestrictions> containerRelevantViewRestrictionsMap = contentRelevantViewRestrictionsOptional.get();
        HashMap<ContentId, RelevantViewRestrictions> relevantViewRestrictionsMap = new HashMap<ContentId, RelevantViewRestrictions>();
        for (Map.Entry<ContentId, RelevantViewRestrictions> entry : containerRelevantViewRestrictionsMap.entrySet()) {
            if (containerIdToContentIdMap.containsKey((Object)entry.getKey())) {
                Collection childContentIds = containerIdToContentIdMap.get((Object)entry.getKey());
                childContentIds.forEach(childContentId -> relevantViewRestrictionsMap.put((ContentId)childContentId, (RelevantViewRestrictions)entry.getValue()));
                continue;
            }
            relevantViewRestrictionsMap.put(entry.getKey(), entry.getValue());
        }
        return Optional.of(relevantViewRestrictionsMap);
    }

    private Multimap<ContentId, ContentId> mapContainerIdToContentIdMap(Multimap<ContentEntityObject, ContentEntityObject> containerToContentMap) {
        ArrayListMultimap containerIdToContentIdMap = ArrayListMultimap.create();
        for (ContentEntityObject ceo : containerToContentMap.keySet()) {
            Collection values = containerToContentMap.get((Object)ceo);
            for (ContentEntityObject value : values) {
                containerIdToContentIdMap.put((Object)ceo.getContentId(), (Object)value.getContentId());
            }
        }
        return containerIdToContentIdMap;
    }

    private Multimap<ContentEntityObject, ContentEntityObject> makeContainerToContentMap(Iterable<? extends ContentEntityObject> entities) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ContentEntityObject contentEntityObject : entities) {
            if (contentEntityObject instanceof Contained) {
                ContentEntityObject container = ContentFactory.getRootContainer((Contained)contentEntityObject);
                result.put((Object)container, (Object)contentEntityObject);
                continue;
            }
            result.put((Object)contentEntityObject, (Object)contentEntityObject);
        }
        return result;
    }

    public static ContentEntityObject getRootContainer(Contained<?> entity) {
        ContentEntityObject container;
        ContentEntityObject containedEntity = entity.getContainer();
        int loopCount = 0;
        while (containedEntity instanceof Contained && loopCount++ < maxSupportedNestedLevel && (container = ((Contained)containedEntity).getContainer()) != null) {
            containedEntity = container;
            if (loopCount < maxSupportedNestedLevel) continue;
            logger.error("Could not find root container for content with id {}", (Object)containedEntity.getId());
        }
        return containedEntity;
    }

    private void addCommonFieldsToBuilders(Map<ContentEntityObject, Content.ContentBuilder> contentMap, Expansions expansions) {
        Fauxpansions historyFauxpansions = Fauxpansions.fauxpansions(expansions, "history");
        Map<ContentEntityObject, Reference<History>> historyMap = this.historyFactory.buildReferences(contentMap.keySet(), historyFauxpansions, this);
        for (Map.Entry<ContentEntityObject, Reference<History>> historyEntry : historyMap.entrySet()) {
            contentMap.get(historyEntry.getKey()).history(historyEntry.getValue());
        }
        Map<ContentEntityObject, Map<String, Object>> metadata = this.metadataFactory.buildMetadataForContentEntityObjects(Maps.transformEntries(contentMap, (k, v) -> () -> ((Supplier)Suppliers.memoize(() -> ((Content.ContentBuilder)v).build())).get()), Fauxpansions.fauxpansions(expansions, "metadata"));
        for (Map.Entry<ContentEntityObject, Map<String, Object>> entry : metadata.entrySet()) {
            contentMap.get(entry.getKey()).metadata(entry.getValue());
        }
    }

    void addCommonFieldsToBuilder(Content.ContentBuilder builder, ContentEntityObject entity, Expansions expansions) {
        Option<String> tinyUrlOption;
        ContentConvertible convertibleEntity = (ContentConvertible)entity;
        ContentSelector selector = entity.getSelector();
        ContentId newId = selector.getId();
        builder.id(newId);
        builder.container(this.makeContainerReference(convertibleEntity, expansions));
        builder.status(entity.getContentStatusObject());
        builder.title(entity.getDisplayTitle());
        builder.addLink(LinkType.WEB_UI, entity.getUrlPath());
        if (entity instanceof AbstractPage) {
            builder.addLink(LinkType.EDIT_UI, ((AbstractPage)entity).getEditUrlPath());
        }
        if (!(tinyUrlOption = this.makeOptionalTinyUrl(entity)).isEmpty()) {
            builder.addLink(LinkType.TINY_UI, (String)tinyUrlOption.get());
        }
        for (Link link : this.extensionsFactory.buildLinks(convertibleEntity)) {
            builder.addLink(link);
        }
        builder.extensions(this.extensionsFactory.buildExtensions(convertibleEntity, expansions.getSubExpansions(EXTENSIONS)));
        builder.position(this.getPosition(this.extensionsFactory.buildExtensions(convertibleEntity, expansions.getSubExpansions(EXTENSIONS)).get("position")));
        builder.space(this.makeSpaceReference((Versioned)entity, expansions));
        builder.version(this.versionFactory.buildRef(entity, Fauxpansions.fauxpansions(expansions, "version"), this));
        builder.children(this.childContentFactory.buildFrom(selector, Depth.ROOT, Fauxpansions.fauxpansions(expansions, "children")));
        builder.descendants(this.childContentFactory.buildFrom(selector, Depth.ALL, Fauxpansions.fauxpansions(expansions, "descendants")));
        builder.operations(this.makeOperations(entity, expansions));
        builder.restrictions(this.makeRestrictions(entity, Fauxpansions.fauxpansions(expansions, "restrictions")));
    }

    private int getPosition(Object position) {
        if (position == null) {
            return -1;
        }
        return ((Position)position).getPosition();
    }

    private Optional<RelevantViewRestrictions> getRelevantViewRestrictionsForContent(Optional<Map<ContentId, RelevantViewRestrictions>> contentRelevantViewRestrictionsOptional, ContentEntityObject entity, Expansions expansions) {
        if (!expansions.canExpand("relevantViewRestrictions")) {
            return Optional.empty();
        }
        if (contentRelevantViewRestrictionsOptional.isEmpty()) {
            throw new IllegalStateException("Missing required inherited read restrictions");
        }
        Expansions subExpansions = expansions.getSubExpansions("relevantViewRestrictions");
        subExpansions.checkRecursiveExpansion("content");
        Map<ContentId, RelevantViewRestrictions> relevantViewRestrictionsMap = contentRelevantViewRestrictionsOptional.get();
        if (!relevantViewRestrictionsMap.containsKey(entity.getContentId())) {
            throw new IllegalStateException("relevant view restrictions is missing for content " + String.valueOf(entity.getContentId()));
        }
        return Optional.of(relevantViewRestrictionsMap.get(entity.getContentId()));
    }

    private Map<OperationKey, ContentRestriction> makeRestrictions(ContentEntityObject entity, Fauxpansions fauxpansions) {
        if (!fauxpansions.canExpand()) {
            return BuilderUtils.collapsedMap((Navigation.Builder)this.navigationService.createNavigation().content(entity.getSelector()).restrictionByOperation());
        }
        Expansions subExpansions = fauxpansions.getSubExpansions();
        subExpansions.checkRecursiveExpansion("content");
        return this.contentRestrictionService.getRestrictionsGroupByOperation(entity.getContentId(), subExpansions.toArray());
    }

    private Iterable<OperationCheckResult> makeOperations(ContentEntityObject entity, Expansions expansions) {
        if (!expansions.canExpand("operations")) {
            return BuilderUtils.collapsedList();
        }
        Expansions subExpansions = expansions.getSubExpansions("operations");
        subExpansions.checkRecursiveExpansion("operations");
        return this.operationService.getAvailableOperations(Target.forModelObject((Object)this.buildFrom(entity, ExpansionsParser.parseAsExpansions((String)"container"))));
    }

    private Map<ContentRepresentation, ContentBody> makeContentBodies(ContentEntityObject entity, Expansions expansions) {
        if (!expansions.canExpand("body")) {
            return BuilderUtils.collapsedMap();
        }
        Expansions bodyExpansions = expansions.getSubExpansions("body");
        bodyExpansions.checkRecursiveExpansion("body");
        return this.contentBodyFactory.makeContentBodies(entity, entity.getBodyContent(), bodyExpansions, this);
    }

    private Reference<? extends Container> makeContainerReference(ContentConvertible entity, Expansions expansions) {
        Expansions subExpansions;
        boolean expand = expansions.canExpand("container");
        if (expand) {
            subExpansions = expansions.getSubExpansions("container");
            subExpansions.checkRecursiveExpansion("container");
        } else {
            subExpansions = Expansions.EMPTY;
        }
        Optional<Object> optionalContainer = this.extensionsFactory.containerEntity(entity, subExpansions);
        if (optionalContainer.isEmpty()) {
            return expand ? Reference.empty(Container.class) : Reference.collapsed(Container.class);
        }
        Object containerEntity = optionalContainer.get();
        if (containerEntity instanceof Draft) {
            Draft draft = (Draft)containerEntity;
            ContentType contentType = ContentType.valueOf((String)draft.getDraftType());
            Content draftContent = Content.builder().type(contentType).id(ContentId.deserialise((String)draft.getIdAsString())).title(draft.getTitle()).status(ContentStatus.DRAFT).build();
            return expand ? Reference.to((Object)draftContent) : Content.buildReference((ContentSelector)draft.getSelector());
        }
        if (containerEntity instanceof ContentEntityObject) {
            ContentEntityObject ceo = (ContentEntityObject)containerEntity;
            return expand ? Reference.to((Object)this.buildFrom(ceo, subExpansions)) : Content.buildReference((ContentSelector)ceo.getSelector());
        }
        if (containerEntity instanceof Space) {
            return expand ? Reference.to((Object)this.spaceFactory.buildFrom((Space)containerEntity, subExpansions)) : com.atlassian.confluence.api.model.content.Space.buildReference((String)((Space)containerEntity).getKey());
        }
        if (containerEntity instanceof Container) {
            return expand ? Reference.to((Object)((Container)containerEntity)) : Reference.collapsed((Object)((Container)containerEntity));
        }
        throw new IllegalStateException("Unknown container of type " + String.valueOf(containerEntity.getClass()) + " on entity " + String.valueOf(entity.getContentId()));
    }

    private Option<String> makeOptionalTinyUrl(Object entity) {
        if (entity instanceof AbstractPage) {
            TinyUrl tinyUrl = new TinyUrl((AbstractPage)entity);
            return Option.some((Object)("/x/" + tinyUrl.getIdentifier()));
        }
        return Option.none(String.class);
    }

    private Iterable<Content> makeAncestry(Versioned entity, Expansions expansions) {
        List<Object> ancestors;
        if (!expansions.canExpand("ancestors")) {
            return BuilderUtils.collapsedList();
        }
        Expansions subExpansions = expansions.getSubExpansions("ancestors");
        subExpansions.checkRecursiveExpansion("ancestors");
        ContentEntityObject latestVersion = (ContentEntityObject)entity.getLatestVersion();
        if (latestVersion instanceof Page) {
            Page page = (Page)latestVersion;
            if (page.getAncestors().contains(null)) {
                ancestors = new ArrayList();
                for (Page parent = page.getParent(); parent != null; parent = parent.getParent()) {
                    ancestors.add(parent);
                }
                ancestors = Lists.reverse(ancestors);
            } else {
                ancestors = new ArrayList(page.getAncestors());
            }
        } else if (latestVersion instanceof Comment) {
            ancestors = new ArrayList<Object>();
            Comment comment = (Comment)latestVersion;
            for (Comment parent = comment.getParent(); parent != null; parent = parent.getParent()) {
                ancestors.add(parent);
            }
        } else {
            return ImmutableList.of();
        }
        return this.buildFrom(ancestors, subExpansions);
    }

    private Reference<com.atlassian.confluence.api.model.content.Space> makeSpaceReference(Versioned entity, Expansions expansions) {
        Space space = null;
        if (entity instanceof Spaced) {
            space = ((Spaced)entity.getLatestVersion()).getSpace();
        }
        if (expansions.canExpand("space")) {
            return space == null ? Reference.empty(com.atlassian.confluence.api.model.content.Space.class) : Reference.to((Object)this.spaceFactory.buildFrom(space, expansions.getSubExpansions("space")));
        }
        return space == null ? Reference.collapsed(com.atlassian.confluence.api.model.content.Space.class) : com.atlassian.confluence.api.model.content.Space.buildReference((String)space.getKey());
    }
}

