/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LabelledContentSpaceValidator {
    private final LabelManager labelManager;
    private final PermissionManager permissionManager;
    private final int batchSize;

    public LabelledContentSpaceValidator(@NonNull LabelManager labelManager, @NonNull PermissionManager permissionManager, int batchSize) {
        this.labelManager = labelManager;
        this.permissionManager = permissionManager;
        this.batchSize = batchSize;
    }

    public boolean validate(Collection<Label> labels, Space space) {
        List contents;
        if (labels.isEmpty()) {
            return true;
        }
        int iteration = 0;
        do {
            contents = this.labelManager.getContentInSpaceForAllLabels(iteration, this.batchSize, space.getKey(), (Label[])labels.toArray(Label[]::new)).getList();
            for (ContentEntityObject content : contents) {
                if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)content)) continue;
                return true;
            }
            iteration += this.batchSize;
        } while (contents.size() == this.batchSize);
        return false;
    }
}

