package com.atlassian.confluence.compat.setup.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;

import java.io.Reader;
import java.io.Writer;

/**
 * Provides version-agnostic implementations for XStream methods.
 */
interface XStreamCompat {
    /**
     * Serialize an object to a pretty-printed XML String.
     */
    String toXML(Object obj);

    /**
     * Serialize an object to the given Writer as pretty-printed XML. The Writer will be flushed afterwards and in case
     * of an exception.
     */
    void toXML(Object obj, Writer writer);

    /**
     * Deserialize an object from an XML String.
     */
    Object fromXML(String xml);

    /**
     * Deserialize an object from an XML Reader.
     */
    Object fromXML(Reader reader);

    /**
     * Provides way to access 1.1.1 XStream object
     * Supposed to be removed when Confluence 7.9 is EOL.
     *
     * @return XStream 1.1.1 equivalent object.
     */
    XStream getXStream();

    /**
     * Register a converter with the appropriate priority.
     *
     * @param converter XStream converter to register
     * @param priority Priority to be used in XStream
     */
    void registerConverter(Converter converter, Integer priority);

    /**
     * Alias a Class to a shorter name to be used in XML elements.
     *
     * @param name Short name
     * @param type  Type to be aliased
     */
    void alias(String name, Class<?> type);

}
