package com.atlassian.confluence.compat.plugin.descriptor.web.urlreadingconditions.accessmode;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.DimensionAwareUrlReadingCondition;
import com.atlassian.webresource.api.prebake.Dimensions;

import java.util.Map;

public class ReadWriteAccessModeUrlReadingCondition implements DimensionAwareUrlReadingCondition {
    private final AccessModeCompatService accessModeCompatService;

    public ReadWriteAccessModeUrlReadingCondition(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    @Override
    public Dimensions computeDimensions() {
        return Dimensions.empty();
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder, Coordinate coordinate) {
        // no-op
    }

    @Override
    public void init(Map<String, String> map) throws PluginParseException {
        // no-op
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder) {
        // no-op
    }

    @Override
    public boolean shouldDisplay(QueryParams queryParams) {
        return !accessModeCompatService.isReadOnlyAccessModeEnabled();
    }
}
