package com.atlassian.confluence.compat.api.service.accessmode;

import com.atlassian.confluence.api.service.exceptions.ServiceException;

import java.util.concurrent.Callable;

/**
 * Compatibility wrapper for AccessModeService, which is only available since Confluence 6.9.0
 * Service to check whether Confluence enable read-only mode or not
 * @since 1.1.0
 */
public interface AccessModeCompatService {
    boolean isReadOnlyAccessModeEnabled();

    /**
     * Execute a method that needs to be exempt from read-only access check in the permission manager layer.
     * @param callable the method
     * @param <T> the return type of the method
     * @return the value returned by the callable method
     * @throws ServiceException the exception thrown by the reflection API or the real service.
     */
    <T> T withReadOnlyAccessExemption(Callable<T> callable) throws ServiceException;
}
