package com.atlassian.confluence.compat.api.service.accessmode.impl;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.spring.container.LazyComponentReference;
import com.atlassian.util.concurrent.Supplier;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

@Component
public class DefaultAccessModeCompatService implements AccessModeCompatService {
    private Supplier accessModeServiceSupplier = new LazyComponentReference("accessModeService");

    public boolean isReadOnlyAccessModeEnabled() {
        try {
            Class<?> accessModeServiceClass = Class.forName("com.atlassian.confluence.api.service.accessmode.AccessModeService");
            Method isReadOnlyAccessModeEnabledMethod = accessModeServiceClass.getDeclaredMethod("isReadOnlyAccessModeEnabled");
            return (Boolean) isReadOnlyAccessModeEnabledMethod.invoke(getAccessModeService());
        } catch (Exception e) {
            // no-op
        }
        return false;
    }

    @Override
    public <T> T withReadOnlyAccessExemption(Callable<T> callable) throws ServiceException {
        try {
            Class<?> accessModeServiceClass = Class.forName("com.atlassian.confluence.api.service.accessmode.AccessModeService");
            Method withReadOnlyAccessExemptionMethod = accessModeServiceClass.getDeclaredMethod("withReadOnlyAccessExemption", Callable.class);
            return (T) withReadOnlyAccessExemptionMethod.invoke(getAccessModeService(), callable);
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            throw new ServiceException("Cannot run the callable", e);
        }
    }

    private Object getAccessModeService() {
        return accessModeServiceSupplier.get();
    }
}