/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.hazelcast.hibernate;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.cache.hazelcast.hibernate.EvictQueryRegionsRequestEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.event.api.EventPublisher;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryCacheSplitBrainDetector
implements LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(QueryCacheSplitBrainDetector.class);
    private final ClusterManager clusterManager;
    private final HazelcastInstance hazelcastInstance;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final SessionFactory sessionFactory;
    private final EventPublisher eventPublisher;
    private volatile UUID lifecycleListenerId;

    QueryCacheSplitBrainDetector(ClusterManager clusterManager, HazelcastInstance hazelcastInstance, EventListenerRegistrar eventListenerRegistrar, SessionFactory sessionFactory, EventPublisher eventPublisher) {
        this.clusterManager = clusterManager;
        this.hazelcastInstance = hazelcastInstance;
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.sessionFactory = sessionFactory;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    void registerTenancyListener() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PostConstruct
    void initClusterListener() {
        if (this.clusterManager.isClustered()) {
            this.lifecycleListenerId = this.hazelcastInstance.getLifecycleService().addLifecycleListener((LifecycleListener)this);
        }
    }

    @PreDestroy
    void unregisterClusterListener() {
        if (this.lifecycleListenerId != null) {
            this.hazelcastInstance.getCluster().removeMembershipListener(this.lifecycleListenerId);
        }
    }

    @PreDestroy
    void unregisterTenancyListener() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onRemoteEvent(ClusterEventWrapper wrapper) {
        ClusterEvent event = wrapper.getEvent();
        if (event instanceof EvictQueryRegionsRequestEvent) {
            log.warn("As a node rejoined the cluster again, all cached data from all query regions will be evicted.");
            this.evictQueryRegionsLocally();
        }
    }

    private void onNodeMergeEvent() {
        log.warn("This node rejoined the cluster again. Cached data from all query regions will be evicted. Other nodes will be notified as well.");
        this.evictQueryRegionsLocally();
        this.eventPublisher.publish((Object)new EvictQueryRegionsRequestEvent(this));
    }

    private void evictQueryRegionsLocally() {
        this.sessionFactory.getCache().evictQueryRegions();
    }

    public void stateChanged(LifecycleEvent event) {
        log.debug("Hazelcast instance state changed to {}", (Object)event.getState());
        if (LifecycleEvent.LifecycleState.MERGED.equals((Object)event.getState())) {
            this.onNodeMergeEvent();
        }
    }
}

