/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast.monitoring;

import com.atlassian.confluence.cluster.hazelcast.monitoring.HazelcastMemberAddedAnalyticsEvent;
import com.atlassian.confluence.cluster.hazelcast.monitoring.HazelcastMemberRemovedAnalyticsEvent;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableMap;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HazelcastMembershipListener
implements InitialMembershipListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastMembershipListener.class);
    private final ComponentMonitor monitor;
    private final EventPublisher eventPublisher;

    HazelcastMembershipListener(ComponentMonitor monitor, EventPublisher eventPublisher) {
        this.monitor = Objects.requireNonNull(monitor);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    public void memberAdded(MembershipEvent event) {
        log.info("memberAdded: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberAdded: cluster contains {}", (Object)member.toString());
        }
        this.alertMembershipChange(1001, event);
        this.eventPublisher.publish((Object)new HazelcastMemberAddedAnalyticsEvent(event.getMembers().size()));
    }

    public void memberRemoved(MembershipEvent event) {
        log.info("memberRemoved: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberRemoved: cluster contains {}", (Object)member.toString());
        }
        this.alertMembershipChange(1002, event);
        this.eventPublisher.publish((Object)new HazelcastMemberRemovedAnalyticsEvent(event.getMembers().size()));
    }

    public void init(InitialMembershipEvent event) {
        log.info("init: cluster {}", (Object)event.getCluster());
        for (Member member : event.getMembers()) {
            log.info("init: cluster contains {}", (Object)member.toString());
        }
    }

    private void alertMembershipChange(int issueId, MembershipEvent event) {
        if (this.monitor != null && this.monitor.isEnabled()) {
            this.monitor.getIssue(issueId).ifPresent(issue -> this.monitor.alert(new AlertRequest.Builder(issue).timestamp(Instant.now()).details(() -> ImmutableMap.of((Object)"member", (Object)event.getMember().toString())).build()));
        }
    }
}

