/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.hazelcast.HazelcastUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.hazelcast.cluster.Member;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HazelcastClusterNodeInformation
implements ClusterNodeInformation {
    private final Member member;
    private final Supplier<String> nodeIdentifierRef;

    HazelcastClusterNodeInformation(Member member) {
        this.member = (Member)Preconditions.checkNotNull((Object)member);
        this.nodeIdentifierRef = Suppliers.memoize(() -> HazelcastUtils.getMemberId(member));
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.member.getSocketAddress();
    }

    public @NonNull String getAnonymizedNodeIdentifier() {
        return this.nodeIdentifierRef.get();
    }

    public @NonNull Optional<String> humanReadableNodeName() {
        return HazelcastUtils.getConfiguredMemberName(this.member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HazelcastClusterNodeInformation that = (HazelcastClusterNodeInformation)obj;
        return Objects.equals(this.member, that.member);
    }

    public String toString() {
        return this.member.toString();
    }

    public boolean isLocal() {
        return this.member.localMember();
    }
}

