/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast.shareddata;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.cluster.shareddata.SharedData;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;

@Internal
public class HazelcastSharedDataSupport {
    public static final String PREFIX = "confluenceHazelcastSharedData.";
    private final String namePrefix;
    private final Supplier<HazelcastInstance> hazelcastRef;

    public HazelcastSharedDataSupport(String namePrefix, Supplier<HazelcastInstance> hazelcastRef) {
        this.namePrefix = PREFIX + (String)Preconditions.checkNotNull((Object)namePrefix);
        this.hazelcastRef = (Supplier)Preconditions.checkNotNull(hazelcastRef);
    }

    @Nonnull
    <K extends Serializable, V extends Serializable> IMap<K, V> getSharedMap(String name) {
        String qualifiedName = this.qualified(name);
        return ((HazelcastInstance)this.hazelcastRef.get()).getMap(qualifiedName);
    }

    @Nonnull
    <K extends Serializable> ISet<K> getSharedSet(String name) {
        String qualifiedName = this.qualified(name);
        return ((HazelcastInstance)this.hazelcastRef.get()).getSet(qualifiedName);
    }

    private String qualified(String name) {
        return this.namePrefix + "." + name;
    }

    @Nonnull
    public SharedData getSharedData(String name) {
        final IMap map = this.getSharedMap(name);
        return new SharedData(){

            @Nonnull
            public <K extends Serializable, V extends Serializable> Map<K, V> getMap() {
                return map;
            }
        };
    }
}

