/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.safety.ClusterPanicEvent;
import com.atlassian.confluence.cluster.safety.ClusterSafetyDao;
import com.atlassian.confluence.cluster.safety.ClusterSafetyManager;
import com.atlassian.confluence.util.profiling.ActivityMonitor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterSafetyManager
implements ClusterSafetyManager {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterSafetyManager.class);
    static final String NOT_FOUND_STATEMENT = "not found";
    static final String SAFETY_NUMBER = "safety-number";
    static final String SAFETY_NUMBER_MODIFIER = "safety-number-member";
    public static final String SAFETY_MAP_PREFIX = HazelcastClusterSafetyManager.class.getSimpleName();
    static final String SAFETY_NUMBER_MAP_NAME = SAFETY_MAP_PREFIX + ".safetyNumber";
    static final String SAFETY_MODIFIER_MAP_NAME = SAFETY_MAP_PREFIX + ".safetyNumberModifier";
    @VisibleForTesting
    static final String CLUSTER_SAFETY_JOB_LOCK_NAME = "com.atlassian.confluence.cluster.hazelcast.HazelcastClusterSafetyManager.clusterSafetyJob";
    private final Random random = new Random();
    private final ClusterSafetyDao clusterSafetyDao;
    private final EventPublisher eventPublisher;
    private final Supplier<HazelcastInstance> instanceSupplier;
    private final ClusterManager clusterManager;
    private final ActivityMonitor activityMonitor;
    private final ScheduledExecutorService executor;
    private final ClusterLockService clusterLockService;
    private final long clusterLockWailTime = Long.valueOf(System.getProperty("cluster.safety.lock.wait.time.ms", "60000"));
    private final Supplier<String> nodeName;

    public HazelcastClusterSafetyManager(ClusterSafetyDao clusterSafetyDao, EventPublisher eventPublisher, final ClusterManager clusterManager, Supplier<HazelcastInstance> instanceSupplier, ActivityMonitor activityMonitor, ScheduledExecutorService executor, ClusterLockService clusterLockService) {
        this.instanceSupplier = (Supplier)Preconditions.checkNotNull(instanceSupplier);
        this.clusterSafetyDao = (ClusterSafetyDao)Preconditions.checkNotNull((Object)clusterSafetyDao);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.clusterManager = (ClusterManager)Preconditions.checkNotNull((Object)clusterManager);
        this.activityMonitor = (ActivityMonitor)Preconditions.checkNotNull((Object)activityMonitor);
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        this.clusterLockService = Objects.requireNonNull(clusterLockService);
        this.nodeName = new LazyReference<String>(){

            protected String create() throws Exception {
                ClusterNodeInformation info = clusterManager.getThisNodeInformation();
                return info == null ? HazelcastClusterSafetyManager.NOT_FOUND_STATEMENT : info.getAnonymizedNodeIdentifier();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() {
        block9: {
            ClusterLock clusterLock = this.clusterLockService.getLockForName(CLUSTER_SAFETY_JOB_LOCK_NAME);
            Stopwatch stopwatch = new Stopwatch().start();
            try {
                if (clusterLock.tryLock(this.clusterLockWailTime, TimeUnit.MILLISECONDS)) {
                    try {
                        this.doVerify();
                        break block9;
                    }
                    finally {
                        clusterLock.unlock();
                    }
                }
                log.info("Node {}: Failed to obtain cluster lock: timed out (waiting threshold {}ms, waiting time {}ms)", new Object[]{this.nodeName.get(), this.clusterLockWailTime, stopwatch.stop().elapsedMillis()});
                this.doVerify();
            }
            catch (InterruptedException e) {
                log.warn("Node {}: Try cluster lock is interrupted", this.nodeName.get(), (Object)e);
            }
            finally {
                stopwatch.stop();
            }
        }
    }

    @VisibleForTesting
    void doVerify() {
        int nextValue = this.getNextValue();
        Optional<String> lastCacheModifier = this.getLastCacheModifier();
        Optional<Integer> dbSafetyNumber = this.getDbSafetyNumber();
        Optional<Integer> cacheSafetyNumber = this.getCacheSafetyNumber();
        if (dbSafetyNumber.isPresent() && cacheSafetyNumber.isPresent()) {
            if (!dbSafetyNumber.equals(cacheSafetyNumber)) {
                log.warn("detected different number in database [ {} ] and cache [ {} ]. Cache number last set by [ {} ]. Triggering panic on current node", new Object[]{dbSafetyNumber.get(), cacheSafetyNumber.get(), lastCacheModifier.or((Object)NOT_FOUND_STATEMENT)});
                this.logDetails(nextValue);
                this.panic();
                return;
            }
        } else if (dbSafetyNumber.isPresent()) {
            log.debug("found cluster safety number in database [ {} ] but not in cache", dbSafetyNumber.get());
        } else if (cacheSafetyNumber.isPresent()) {
            log.debug("found cluster safety number in cache [ {} ] but not in database", this.getCacheSafetyNumber());
        }
        this.logDetails(nextValue);
        this.clusterSafetyDao.setSafetyNumber(nextValue);
        this.storeCacheNumber(nextValue);
        this.sanityCheck(this.getDbSafetyNumber(), this.getCacheSafetyNumber(), nextValue);
    }

    private void sanityCheck(Optional<Integer> dbSafetyNumber, Optional<Integer> cacheSafetyNumber, int nextValue) {
        if (!dbSafetyNumber.isPresent()) {
            log.warn("Unable to get database safety number immediately after setting it. This may indicate a serious issue with database connectivity");
        } else if (!cacheSafetyNumber.isPresent()) {
            log.warn("Unable to get cache safety number immediately after setting it. This may indicate traffic is being lost between cluster nodes");
        } else if (!dbSafetyNumber.equals(cacheSafetyNumber)) {
            log.warn("detected different number in database [ {} ] and cache [ {} ], immediately after setting them to be the same value | {} |. This will probably cause a cluster panic on next job execution", new Object[]{dbSafetyNumber.get(), cacheSafetyNumber.get(), nextValue});
        }
    }

    private void logDetails(int nextValue) {
        if (this.isLogEnabled()) {
            Optional<Integer> dbSafetyNumber = this.getDbSafetyNumber();
            Optional<Integer> cacheSafetyNumber = this.getCacheSafetyNumber();
            Optional<String> lastCacheModifier = this.getLastCacheModifier();
            String dbSafetyNumberString = dbSafetyNumber.isPresent() ? String.valueOf(dbSafetyNumber.get()) : NOT_FOUND_STATEMENT;
            log.debug("Database number exists [ {} ] [ {} ]", (Object)dbSafetyNumber.isPresent(), (Object)dbSafetyNumberString);
            String cacheSafetyNumberString = cacheSafetyNumber.isPresent() ? String.valueOf(cacheSafetyNumber.get()) : NOT_FOUND_STATEMENT;
            log.debug("Cached number exists [ {} ] [ {} ], last modifier: [ {} ]", new Object[]{cacheSafetyNumber.isPresent(), cacheSafetyNumberString, lastCacheModifier.or((Object)NOT_FOUND_STATEMENT)});
            if (dbSafetyNumber.isPresent() && cacheSafetyNumber.isPresent()) {
                log.debug("Database number: {} should equal cached number: {}", (Object)dbSafetyNumberString, (Object)cacheSafetyNumberString);
            }
            log.debug("Next value: {}", (Object)nextValue);
        }
    }

    private void panic() {
        this.logRuntimeInfo();
        if (this.clusterManager.isClustered()) {
            try {
                ClusterNodeInformation info = this.clusterManager.getThisNodeInformation();
                this.eventPublisher.publish((Object)new ClusterPanicEvent((Object)this, "[Origin node: " + (String)this.nodeName.get() + " listening on " + info.getLocalSocketAddress() + "] Clustered Confluence: Database is being updated by an instance which is not part of the current cluster. You should check network connections between cluster nodes, especially multicast traffic."));
            }
            finally {
                this.clusterManager.stopCluster();
            }
        } else {
            this.eventPublisher.publish((Object)new ClusterPanicEvent((Object)this, "Non Clustered Confluence: Database is being updated by another Confluence instance. Please see http://confluence.atlassian.com/x/mwiyCg for more details."));
        }
    }

    private void logRuntimeInfo() {
        try {
            Future<String> runtimeDetails = this.executor.submit(this.getRuntimeInfo());
            String debugInfo = runtimeDetails.get(10L, TimeUnit.SECONDS);
            log.error(debugInfo);
        }
        catch (Exception e) {
            log.error("Unable to get debug dump before triggering cluster panic", (Throwable)e);
        }
    }

    private Callable<String> getRuntimeInfo() {
        return () -> {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            String totalThreadDump = stackTraces.entrySet().stream().map(e -> ((Thread)e.getKey()).toString() + Joiner.on((String)"\n\t").join((Object[])e.getValue())).collect(Collectors.toList()).stream().collect(Collectors.joining("\n"));
            Collection activities = this.activityMonitor.snapshotCurrent();
            String totalActivityDump = activities.stream().map(Object::toString).collect(Collectors.joining("\n"));
            return Stream.of("====DEBUG DUMP START", "THREADS", totalThreadDump, "ACTIVITIES", totalActivityDump, "====DEBUG DUMP END====").collect(Collectors.joining("\n"));
        };
    }

    private int getNextValue() {
        return this.random.nextInt();
    }

    private Optional<Integer> getCacheSafetyNumber() {
        return Optional.fromNullable((Object)this.getSafetyNumberMap().get((Object)SAFETY_NUMBER));
    }

    private Optional<String> getLastCacheModifier() {
        return Optional.fromNullable((Object)this.getSafetyNumberModifierMap().get((Object)SAFETY_NUMBER_MODIFIER));
    }

    private Optional<Integer> getDbSafetyNumber() {
        return Optional.fromNullable((Object)this.clusterSafetyDao.getSafetyNumber());
    }

    private void storeCacheNumber(int value) {
        this.getSafetyNumberModifierMap().put((Object)SAFETY_NUMBER_MODIFIER, this.nodeName.get());
        this.getSafetyNumberMap().put((Object)SAFETY_NUMBER, (Object)value);
    }

    private IMap<String, Integer> getSafetyNumberMap() {
        return ((HazelcastInstance)this.instanceSupplier.get()).getMap(SAFETY_NUMBER_MAP_NAME);
    }

    private IMap<String, String> getSafetyNumberModifierMap() {
        return ((HazelcastInstance)this.instanceSupplier.get()).getMap(SAFETY_MODIFIER_MAP_NAME);
    }

    @VisibleForTesting
    boolean isLogEnabled() {
        return log.isDebugEnabled();
    }
}

