/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.annotations.Internal;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.config.ApplicationConfig;
import com.atlassian.confluence.cache.hazelcast.DefaultHazelcastHelper;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterInvariants;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.ClusteredLock;
import com.atlassian.confluence.cluster.EmptyClusterInformation;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.cluster.hazelcast.CollectClusterInvariants;
import com.atlassian.confluence.cluster.hazelcast.CollectNodeStatus;
import com.atlassian.confluence.cluster.hazelcast.ConfluenceHazelcastConfigBuilder;
import com.atlassian.confluence.cluster.hazelcast.DualLock;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusterEventService;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusterInformation;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusterNodeInformation;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusteredFifoBuffer;
import com.atlassian.confluence.cluster.hazelcast.HazelcastDualLock;
import com.atlassian.confluence.cluster.hazelcast.HazelcastExecutorClusterEventService;
import com.atlassian.confluence.cluster.hazelcast.HazelcastUtils;
import com.atlassian.confluence.cluster.hazelcast.JvmDualLock;
import com.atlassian.confluence.cluster.hazelcast.shareddata.HazelcastSharedDataSupport;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.util.ClusterUtils;
import com.atlassian.core.task.FifoBuffer;
import com.atlassian.hazelcast.serialization.OsgiSafeStreamSerializer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Member;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Internal
public class HazelcastClusterManager
implements ClusterManager,
ClusterLockService,
Supplier<HazelcastInstance>,
com.atlassian.util.concurrent.Supplier<HazelcastInstance> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String EXECUTOR_SVC_NAME = "cluster-manager-executor";
    private static final String FIFO_BUFFER_PREFIX = "confluence.fifo.buffer.";
    private static final String LOCK_CACHE_NAME = "com.atlassian.confluence.lock-cache";
    private static final String LEGACY_PUBLISHED_MAP_NAME = "legacy";
    private final Function<String, JvmDualLock> nonClusterLock = CacheBuilder.newBuilder().build(CacheLoader.from(JvmDualLock::new));
    private final ConcurrentMap<String, Serializable> publishMap = Maps.newConcurrentMap();
    private final AtomicBoolean clusterIsRunning = new AtomicBoolean(false);
    private final ApplicationConfig applicationConfig;
    private final ClassLoader classLoader;
    private final String configResourceName;
    private final SynchronizationManager synchronizationManager;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private final HazelcastSharedDataSupport sharedDataSupport;
    private HazelcastInstance instance;
    private Config instanceConfig;
    private HazelcastClusterEventService clusterEventService;

    public HazelcastClusterManager(ApplicationConfig applicationConfig, ClassLoader classLoader, String configResourceName, SynchronizationManager synchronizationManager, OsgiSafeStreamSerializer osgiSafeStreamSerializer) {
        this.applicationConfig = (ApplicationConfig)Preconditions.checkNotNull((Object)applicationConfig);
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.configResourceName = (String)Preconditions.checkNotNull((Object)configResourceName);
        this.synchronizationManager = (SynchronizationManager)Preconditions.checkNotNull((Object)synchronizationManager);
        this.osgiSafeStreamSerializer = (OsgiSafeStreamSerializer)Preconditions.checkNotNull((Object)osgiSafeStreamSerializer);
        this.sharedDataSupport = new HazelcastSharedDataSupport(this.getClass().getSimpleName(), this);
    }

    public InetAddress resolveName(String name) {
        return ClusterUtils.resolveName((String)((String)Preconditions.checkNotNull((Object)name)));
    }

    public boolean isClusterSupported() {
        return true;
    }

    @Deprecated
    public void publishObject(String key, Serializable object) {
        if (this.isClustered()) {
            this.getSharedMap().put(Preconditions.checkNotNull((Object)key), object);
        } else {
            this.publishMap.put((String)Preconditions.checkNotNull((Object)key), object);
        }
    }

    @Deprecated
    public Serializable getPublishedObject(String key) {
        return this.isClustered() ? (Serializable)this.getSharedMap().get(Preconditions.checkNotNull((Object)key)) : (Serializable)this.publishMap.get(Preconditions.checkNotNull((Object)key));
    }

    @Nonnull
    private <K extends Serializable, V extends Serializable> Map<K, V> getSharedMap() {
        return this.sharedDataSupport.getSharedData(LEGACY_PUBLISHED_MAP_NAME).getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        ApplicationConfig applicationConfig = this.applicationConfig;
        synchronized (applicationConfig) {
            Object isClustered = this.applicationConfig.getProperty((Object)"confluence.cluster");
            return "true".equals(isClustered);
        }
    }

    public int getPermittedClusterNodes() {
        return this.isClustered() ? Integer.MAX_VALUE : 0;
    }

    public ClusterInformation getClusterInformation() {
        return null == this.instance ? new EmptyClusterInformation() : new HazelcastClusterInformation(this.instance);
    }

    public <T> FifoBuffer<T> getFifoBuffer(String name) {
        if (!this.isClustered()) {
            return null;
        }
        Preconditions.checkState((null != this.instance ? 1 : 0) != 0, (Object)"Cluster not started.");
        IQueue queue = this.instance.getQueue(FIFO_BUFFER_PREFIX + (String)Preconditions.checkNotNull((Object)name));
        return new HazelcastClusteredFifoBuffer(queue);
    }

    public void publishEvent(final ConfluenceEvent event) {
        if (!this.isClustered()) {
            return;
        }
        this.synchronizationManager.runOnSuccessfulCommit(new Runnable(){

            @Override
            public void run() {
                HazelcastClusterManager.this.publishEventImmediately(event);
            }

            public String toString() {
                return "Sending remote event: " + event;
            }
        });
    }

    public void publishEventImmediately(ConfluenceEvent event) {
        if (!this.isClustered()) {
            return;
        }
        if (this.clusterEventService != null) {
            this.clusterEventService.publishEventToCluster(event);
        } else {
            log.warn("No clusterEventService present, cannot propagate {} to cluster", (Object)event.getClass().getName());
        }
    }

    public ClusterNodeInformation getThisNodeInformation() {
        return null == this.instance ? null : HazelcastClusterManager.getLocalMemberInfo(this.instance);
    }

    private static HazelcastClusterNodeInformation getLocalMemberInfo(HazelcastInstance instance) {
        return new HazelcastClusterNodeInformation(instance.getCluster().getLocalMember());
    }

    public Collection<ClusterNodeInformation> getAllNodesInformation() {
        return this.isClustered() ? Lists.newArrayList((Iterable)Collections2.transform((Collection)this.instance.getCluster().getMembers(), HazelcastClusterNodeInformation::new)) : Collections.emptySet();
    }

    public void configure(ClusterConfig clusterConfig) {
        this.instanceConfig = new ConfluenceHazelcastConfigBuilder(this.applicationConfig, this.classLoader, this.osgiSafeStreamSerializer, ConfluenceSystemProperties.isDevMode(), new DefaultHazelcastHelper(this)).createHazelcastConfig(clusterConfig, this.configResourceName);
        log.info("Configuring Hazelcast with instanceName [{}], join configuration {}, network interfaces {} and local port {}", new Object[]{this.instanceConfig.getInstanceName(), clusterConfig.getJoinConfig(), this.instanceConfig.getNetworkConfig().getInterfaces().getInterfaces(), this.instanceConfig.getNetworkConfig().getPort()});
    }

    public boolean isConfigured() {
        return null != this.instanceConfig;
    }

    public void reconfigure(ClusterConfig config) {
        this.stopCluster();
        this.configure(config);
        this.startCluster();
    }

    @PreDestroy
    public void stopCluster() {
        this.clusterIsRunning.set(false);
        if (this.clusterEventService != null) {
            this.clusterEventService.stop();
            this.clusterEventService = null;
        }
        if (null != this.instance) {
            log.info("Shutting down the cluster");
            this.instance.shutdown();
            this.instance = null;
            this.instanceConfig = null;
        }
    }

    public void startCluster() {
        Preconditions.checkState((!this.clusterIsRunning.get() ? 1 : 0) != 0, (Object)"Cluster already running");
        Preconditions.checkState((null != this.instanceConfig ? 1 : 0) != 0, (Object)"Cannot start cluster until it has been configured.");
        if (null == this.instance) {
            log.info("Starting the cluster.");
            this.instance = Hazelcast.newHazelcastInstance((Config)this.instanceConfig);
            log.info("Confluence cluster node identifier is [{}]", (Object)HazelcastClusterManager.getLocalMemberInfo(this.instance).getAnonymizedNodeIdentifier());
            String nodeName = ConfluenceSystemProperties.getHumanReadableClusterNodeName();
            if (nodeName != null) {
                log.info("Confluence cluster node name is [{}]", (Object)nodeName);
                HazelcastUtils.setConfiguredMemberName(this.instance.getCluster().getLocalMember(), nodeName);
            }
            this.clusterEventService = new HazelcastExecutorClusterEventService(this.instance);
            this.clusterEventService.start();
            this.clusterIsRunning.set(true);
        } else {
            log.warn("Ignoring a duplicate request to start the cluster.");
        }
    }

    @Deprecated
    public Map<Integer, NodeStatus> getNodeStatuses() {
        if (!this.isClustered()) {
            return Collections.emptyMap();
        }
        IExecutorService svc = this.instance.getExecutorService(EXECUTOR_SVC_NAME);
        TreeMap result = Maps.newTreeMap();
        Map futures = svc.submitToAllMembers((Callable)new CollectNodeStatus(this.instance.getCluster().getLocalMember().getUuid()));
        for (Map.Entry entry : futures.entrySet()) {
            try {
                result.put(HazelcastClusterNodeInformation.generateId((Member)entry.getKey()), ((Future)entry.getValue()).get());
            }
            catch (InterruptedException | ExecutionException ex) {
                log.warn("Ignoring error getting node status from {}", entry.getKey(), (Object)ex);
            }
        }
        return result;
    }

    public Map<ClusterNodeInformation, NodeStatus> getNodeStatusMap() {
        if (!this.isClustered()) {
            return Collections.emptyMap();
        }
        IExecutorService svc = this.instance.getExecutorService(EXECUTOR_SVC_NAME);
        ImmutableMap.Builder result = ImmutableMap.builder();
        CollectNodeStatus collectionTask = new CollectNodeStatus(HazelcastClusterManager.getLocalMemberInfo(this.instance).getAnonymizedNodeIdentifier());
        Map futures = svc.submitToAllMembers((Callable)collectionTask);
        for (Map.Entry resultEntry : futures.entrySet()) {
            Member clusterMember = (Member)resultEntry.getKey();
            try {
                NodeStatus nodeStatus = (NodeStatus)((Future)resultEntry.getValue()).get(3L, TimeUnit.SECONDS);
                result.put((Object)new HazelcastClusterNodeInformation(clusterMember), (Object)nodeStatus);
            }
            catch (InterruptedException ex) {
                log.warn("Thead interrupted whilst getting node status from {}", (Object)clusterMember, (Object)ex);
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException ex) {
                throw new RuntimeException("Failure when getting node status information from " + clusterMember, ex.getCause());
            }
            catch (TimeoutException ex) {
                log.warn("Timed out waiting for node status information from {}", (Object)clusterMember, (Object)ex);
            }
        }
        return result.build();
    }

    public ClusterInvariants getClusterInvariants() throws ClusterException {
        if (!this.isClustered()) {
            return null;
        }
        LinkedHashSet otherMembers = Sets.newLinkedHashSet((Iterable)this.instance.getCluster().getMembers());
        otherMembers.remove(this.instance.getCluster().getLocalMember());
        if (otherMembers.isEmpty()) {
            return null;
        }
        IExecutorService svc = this.instance.getExecutorService(EXECUTOR_SVC_NAME);
        Map futures = svc.submitToMembers((Callable)new CollectClusterInvariants(this.instance.getCluster().getLocalMember().getUuid()), (Collection)otherMembers);
        for (Map.Entry entry : futures.entrySet()) {
            try {
                return (ClusterInvariants)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                log.warn("Ignoring error getting cluster invariants from {}", entry.getKey(), (Object)ex);
            }
        }
        throw new ClusterException("Failed to get invariants from cluster.");
    }

    public DualLock getLockForName(@Nonnull String key) {
        if (this.isClustered()) {
            IMap lockCache = this.instance.getMap(LOCK_CACHE_NAME);
            return new HazelcastDualLock((IMap<String, Serializable>)lockCache, key);
        }
        return (DualLock)this.nonClusterLock.apply((Object)key);
    }

    public ClusteredLock getClusteredLock(String key) {
        return this.getLockForName((String)Preconditions.checkNotNull((Object)key));
    }

    public Lock getLock(String name) {
        return this.getClusteredLock(name);
    }

    public HazelcastInstance get() {
        return this.instance;
    }
}

