/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.annotations.Internal;
import com.atlassian.config.ApplicationConfig;
import com.atlassian.confluence.cache.hazelcast.HazelcastHelper;
import com.atlassian.confluence.cluster.AWSClusterJoinConfig;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterJoinConfig;
import com.atlassian.confluence.cluster.MulticastClusterJoinConfig;
import com.atlassian.confluence.cluster.TCPIPClusterJoinConfig;
import com.atlassian.confluence.cluster.hazelcast.AlwaysNullMapMergePolicy;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusterSafetyManager;
import com.atlassian.hazelcast.serialization.OsgiClassLoaderRegistrySynchronizer;
import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.hazelcast.serialization.OsgiSafeStreamSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.nio.serialization.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class ConfluenceHazelcastConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceHazelcastConfigBuilder.class);
    private static final String LISTEN_PORT_SYSPROP = "confluence.cluster.hazelcast.listenPort";
    private static final String MAX_HEARTBEAT = System.getProperty("confluence.cluster.hazelcast.max.no.heartbeat.seconds", "30");
    private static final int DEFAULT_CACHE_MAP_SYNC_BACKUPS = 0;
    private static final int DEFAULT_CACHE_MAP_ASYNC_BACKUPS = 0;
    private static final long DEFAULT_MIN_EVICTION_CHECK_MILLIS = 1000L;
    private static final int DEFAULT_HAZELCAST_PORT = 5801;
    private static final Collection<String> DEFAULT_OUTBOUND_PORT_DEFINITIONS = ImmutableList.of((Object)"33000-35000");
    private static final Collection<String> DEFAULT_LISTENER_CLASS_NAMES = ImmutableList.of((Object)"com.atlassian.confluence.cache.hazelcast.logging.LoggingInitialMembershipListener", (Object)"com.atlassian.confluence.cache.hazelcast.logging.LoggingLifecycleListener");
    private static final Map<String, String> DEFAULT_HAZELCAST_PROPERTIES = ImmutableMap.builder().put((Object)"hazelcast.logging.type", (Object)"slf4j").put((Object)"hazelcast.heartbeat.interval.seconds", (Object)"1").put((Object)"hazelcast.max.no.heartbeat.seconds", (Object)MAX_HEARTBEAT).put((Object)"hazelcast.operation.call.timeout.millis", (Object)"60000").build();
    private static final String HIBERNATE_CACHES = "atlassian-cache.Cache.net.sf.hibernate.cache.*";
    private static final String HAZELCAST_INSTANCE_NAME = "confluence";
    private final ApplicationConfig applicationConfig;
    private final ClassLoader classLoader;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private final HazelcastHelper hazelcastHelper;
    private final boolean devMode;

    ConfluenceHazelcastConfigBuilder(ApplicationConfig applicationConfig, ClassLoader classLoader, OsgiSafeStreamSerializer osgiSafeStreamSerializer, boolean devMode, HazelcastHelper hazelcastHelper) {
        this.applicationConfig = (ApplicationConfig)Preconditions.checkNotNull((Object)applicationConfig);
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.osgiSafeStreamSerializer = (OsgiSafeStreamSerializer)Preconditions.checkNotNull((Object)osgiSafeStreamSerializer);
        this.devMode = (Boolean)Preconditions.checkNotNull((Object)devMode);
        this.hazelcastHelper = (HazelcastHelper)Preconditions.checkNotNull((Object)hazelcastHelper);
    }

    Config createHazelcastConfig(ClusterConfig clusterConfig, String hazelcastConfigResourceName) {
        Config hazelcastConfig = this.createBaseConfig(hazelcastConfigResourceName);
        hazelcastConfig.setInstanceName(HAZELCAST_INSTANCE_NAME);
        hazelcastConfig.setClassLoader(this.classLoader);
        this.updateNetworkConfig(clusterConfig, hazelcastConfig.getNetworkConfig());
        this.updateSerializationConfig(hazelcastConfig.getSerializationConfig());
        this.updateBaseCacheDataStructureConfig(hazelcastConfig);
        this.updateListenerConfig(hazelcastConfig);
        this.updatePropertiesConfig(hazelcastConfig);
        OsgiClassLoaderRegistrySynchronizer.configure((Config)hazelcastConfig);
        return hazelcastConfig;
    }

    private void updatePropertiesConfig(Config hazelcastConfig) {
        DEFAULT_HAZELCAST_PROPERTIES.entrySet().stream().filter(property -> !this.isPropertyAlreadySet(hazelcastConfig, (String)property.getKey())).forEach(property -> hazelcastConfig.setProperty((String)property.getKey(), (String)property.getValue()));
    }

    private void updateListenerConfig(Config hazelcastConfig) {
        for (String listenerClassName : DEFAULT_LISTENER_CLASS_NAMES) {
            hazelcastConfig.addListenerConfig(new ListenerConfig(listenerClassName));
        }
    }

    private void updateBaseCacheDataStructureConfig(Config hazelcastConfig) {
        hazelcastConfig.addMapConfig(new MapConfig(hazelcastConfig.getMapConfig("default")).setMinEvictionCheckMillis(1000L));
        String baseAtlassianCacheMapName = this.hazelcastHelper.getHazelcastMapNameForCache("*");
        String baseAtlassianCachedReferenceMapName = this.hazelcastHelper.getHazelcastMapNameForCachedReference("*");
        hazelcastConfig.addMapConfig(this.createMapConfig(hazelcastConfig, HIBERNATE_CACHES, false));
        hazelcastConfig.addMapConfig(this.createMapConfig(hazelcastConfig, baseAtlassianCacheMapName, true));
        hazelcastConfig.addMapConfig(this.createMapConfig(hazelcastConfig, baseAtlassianCachedReferenceMapName, true));
        String baseSharedDataName = this.hazelcastHelper.getBaseSharedDataName();
        hazelcastConfig.addMapConfig(new MapConfig(hazelcastConfig.getMapConfig("default")).setName(baseSharedDataName).setBackupCount(1).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setEvictionPolicy(EvictionPolicy.NONE).setMaxSizeConfig(new MaxSizeConfig(Integer.MAX_VALUE, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setNearCacheConfig(null));
        hazelcastConfig.addSetConfig((SetConfig)((SetConfig)((SetConfig)new SetConfig(hazelcastConfig.getSetConfig("default")).setName(baseSharedDataName)).setMaxSize(Integer.MAX_VALUE)).setBackupCount(1));
        hazelcastConfig.addMapConfig(new MapConfig(hazelcastConfig.getMapConfig("default")).setName(HazelcastClusterSafetyManager.SAFETY_MAP_PREFIX + "*").setBackupCount(0).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setEvictionPolicy(EvictionPolicy.NONE).setMaxSizeConfig(new MaxSizeConfig(Integer.MAX_VALUE, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setNearCacheConfig(null).setMergePolicy(AlwaysNullMapMergePolicy.class.getName()));
    }

    private MapConfig createMapConfig(Config hazelcastConfig, String name, boolean withNearCache) {
        NearCacheConfig nearCacheConfig = withNearCache ? new NearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(true) : null;
        return new MapConfig(hazelcastConfig.getMapConfig("default")).setName(name).setBackupCount(0).setAsyncBackupCount(0).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setNearCacheConfig(nearCacheConfig);
    }

    private void updateSerializationConfig(SerializationConfig serializationConfig) {
        serializationConfig.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)this.osgiSafeStreamSerializer).setTypeClass(OsgiSafe.class));
    }

    private void updateNetworkConfig(ClusterConfig confluenceClusterConfig, NetworkConfig networkConfig) {
        InterfacesConfig interfacesConfig = networkConfig.getInterfaces();
        JoinConfig joinConfig = networkConfig.getJoin();
        NetworkInterface configuredNetworkInterface = confluenceClusterConfig.getNetworkInterface();
        if (configuredNetworkInterface != null) {
            ConfluenceHazelcastConfigBuilder.updateInterfacesConfig(interfacesConfig, configuredNetworkInterface);
        }
        this.updateListenPort(networkConfig);
        ConfluenceHazelcastConfigBuilder.updateJoinConfig(confluenceClusterConfig, joinConfig);
    }

    private void updateListenPort(NetworkConfig networkConfig) {
        String portStr = System.getProperty(LISTEN_PORT_SYSPROP);
        NetworkConfig defaultNetworkConfig = new Config().getNetworkConfig();
        if (portStr != null) {
            int listenPort = Integer.parseInt(portStr);
            networkConfig.setPort(listenPort);
        } else if (networkConfig.getPort() == defaultNetworkConfig.getPort()) {
            networkConfig.setPort(5801);
        }
        if (!Objects.equals(defaultNetworkConfig.getOutboundPortDefinitions(), networkConfig.getOutboundPortDefinitions())) {
            networkConfig.setOutboundPortDefinitions(DEFAULT_OUTBOUND_PORT_DEFINITIONS);
        }
        networkConfig.setPortAutoIncrement(this.devMode);
    }

    private static void updateJoinConfig(ClusterConfig confluenceClusterConfig, JoinConfig joinConfig) {
        ClusterJoinConfig clusterJoinConfig = confluenceClusterConfig.getJoinConfig();
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getAwsConfig().setEnabled(false);
        joinConfig.getMulticastConfig().setEnabled(false);
        if (clusterJoinConfig instanceof MulticastClusterJoinConfig) {
            MulticastClusterJoinConfig multicastClusterJoinConfig = (MulticastClusterJoinConfig)clusterJoinConfig;
            joinConfig.getMulticastConfig().setEnabled(true).setMulticastTimeToLive(multicastClusterJoinConfig.getMulticastTTL()).setMulticastGroup(multicastClusterJoinConfig.getMulticastAddress().getHostAddress()).setMulticastPort(multicastClusterJoinConfig.getMulticastPort());
        } else if (clusterJoinConfig instanceof TCPIPClusterJoinConfig) {
            joinConfig.getTcpIpConfig().setEnabled(true).setMembers(((TCPIPClusterJoinConfig)clusterJoinConfig).getPeerAddresses());
        } else if (clusterJoinConfig instanceof AWSClusterJoinConfig) {
            AWSClusterJoinConfig awsJoinConfig = (AWSClusterJoinConfig)clusterJoinConfig;
            joinConfig.getAwsConfig().setEnabled(true).setAccessKey(awsJoinConfig.getAccessKey()).setSecretKey(awsJoinConfig.getSecretKey()).setHostHeader((String)awsJoinConfig.getHostHeader().orElse(null)).setRegion((String)awsJoinConfig.getRegion().orElse(null)).setSecurityGroupName((String)awsJoinConfig.getSecurityGroupName().orElse(null)).setTagKey((String)awsJoinConfig.getTagKey().orElse(null)).setTagValue((String)awsJoinConfig.getTagValue().orElse(null));
        }
    }

    private static void updateInterfacesConfig(InterfacesConfig interfacesConfig, NetworkInterface configuredNetworkInterface) {
        for (InetAddress networkInterfaceAddress : Collections.list(configuredNetworkInterface.getInetAddresses())) {
            interfacesConfig.addInterface(networkInterfaceAddress.getHostAddress());
        }
        interfacesConfig.setEnabled(true);
    }

    private Optional<File> getConfigOverride(String hazelcastConfigResourceName) {
        File configDirectory;
        File configResource;
        Object clusterHome = this.applicationConfig.getProperty((Object)"confluence.cluster.home");
        if (clusterHome != null && (configResource = new File(configDirectory = new File(clusterHome.toString(), "config"), hazelcastConfigResourceName)).exists()) {
            return Optional.of(configResource);
        }
        return Optional.empty();
    }

    private Config createBaseConfig(String hazelcastConfigResourceName) {
        try {
            return this.getConfigInputStream(hazelcastConfigResourceName).map(input -> new XmlConfigBuilder(input).build()).orElse(new Config());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read config", e);
        }
    }

    private Optional<InputStream> getConfigInputStream(String hazelcastConfigResourceName) throws FileNotFoundException {
        Optional<File> sharedConfig = this.getConfigOverride(hazelcastConfigResourceName);
        if (sharedConfig.isPresent()) {
            log.info("Reading Hazelcast config from shared-home location [{}]", (Object)sharedConfig.get().getAbsolutePath());
            return Optional.of(new FileInputStream(sharedConfig.get()));
        }
        return Optional.empty();
    }

    private boolean isPropertyAlreadySet(Config config, String propertyName) {
        Config defaultConfig = new Config();
        return !Objects.equals(defaultConfig.getProperty(propertyName), config.getProperty(propertyName));
    }
}

