/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.monitoring;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.cache.ConfluenceMonitoringCache;
import com.atlassian.confluence.cache.LockingCache;
import com.atlassian.confluence.util.profiling.ConfluenceMonitoring;
import com.atlassian.confluence.util.profiling.Split;
import com.google.common.base.Preconditions;
import org.joda.time.Duration;

@Internal
public class ConfluenceMonitoringLockingCache<K, V>
extends ConfluenceMonitoringCache<K, V>
implements LockingCache<K, V> {
    private final LockingCache<K, V> lockingCache;

    public ConfluenceMonitoringLockingCache(LockingCache<K, V> cache, ConfluenceMonitoring confluenceMonitoring) {
        super(cache, confluenceMonitoring);
        this.lockingCache = (LockingCache)Preconditions.checkNotNull(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(K key, Duration leaseTime) {
        Split split = this.createLockSplit();
        try {
            this.lockingCache.lock(key, leaseTime);
        }
        finally {
            split.stop();
        }
    }

    public void unlock(K key) {
        Split split = this.createUnlockSplit();
        try {
            this.lockingCache.unlock(key);
        }
        finally {
            split.stop();
        }
    }
}

