/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.monitoring;

import com.atlassian.annotations.Internal;
import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.cache.CacheMonitoringUtils;
import com.atlassian.confluence.util.profiling.ConfluenceMonitoring;
import com.atlassian.confluence.util.profiling.Split;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@Internal
public class ConfluenceMonitoringLoader<K, V>
implements CacheLoader<K, V> {
    private final ConfluenceMonitoring confluenceMonitoring;
    private final String cacheName;
    private final CacheLoader<K, V> cacheLoader;

    public ConfluenceMonitoringLoader(ConfluenceMonitoring confluenceMonitoring, String cacheName, CacheLoader<K, V> cacheLoader) {
        this.confluenceMonitoring = (ConfluenceMonitoring)Preconditions.checkNotNull((Object)confluenceMonitoring);
        this.cacheName = (String)Preconditions.checkNotNull((Object)cacheName);
        this.cacheLoader = (CacheLoader)Preconditions.checkNotNull(cacheLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public V load(@Nonnull K key) {
        Split split = this.createLoadSplit();
        try {
            Object object = this.cacheLoader.load(key);
            return (V)object;
        }
        finally {
            split.stop();
        }
    }

    protected Split createLoadSplit() {
        return CacheMonitoringUtils.startSplit((ConfluenceMonitoring)this.confluenceMonitoring, (String)"CACHE", (String[])new String[]{this.cacheName, "LOAD"});
    }
}

