/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.logging;

import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInitialMembershipListener
implements InitialMembershipListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingInitialMembershipListener.class);

    public void memberAdded(MembershipEvent event) {
        log.info("memberAdded: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberAdded: cluster contains {}", (Object)member.toString());
        }
    }

    public void memberRemoved(MembershipEvent event) {
        log.info("memberRemoved: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberRemoved: cluster contains {}", (Object)member.toString());
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
        log.info("memberAttributeChanged: member {}, key {}, value {}", new Object[]{event.getMember(), event.getKey(), event.getValue()});
    }

    public void init(InitialMembershipEvent event) {
        log.info("init: cluster {}", (Object)event.getCluster());
        for (Member member : event.getMembers()) {
            log.info("init: cluster contains {}", (Object)member.toString());
        }
    }
}

