/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.hibernate;

import com.atlassian.confluence.cache.hazelcast.hibernate.CacheValue;
import java.util.Comparator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheStrategy
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCacheStrategy.class);
    private Cache cache;
    private static final CacheConcurrencyStrategy.SoftLock LOCK_SUCCESS = new CacheConcurrencyStrategy.SoftLock(){

        public String toString() {
            return "Lock::Success";
        }
    };
    private static final CacheConcurrencyStrategy.SoftLock LOCK_FAILURE = new CacheConcurrencyStrategy.SoftLock(){

        public String toString() {
            return "Lock::Failure";
        }
    };

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Cache lookup: " + key);
        }
        try {
            boolean gettable;
            this.cache.lock(key);
            CacheValue cacheValue = (CacheValue)this.cache.get(key);
            boolean bl = gettable = cacheValue != null && cacheValue.getTxTimestamp() < txTimestamp;
            if (gettable) {
                if (log.isTraceEnabled()) {
                    log.trace("Cache hit: " + key);
                }
                Object object = cacheValue.getValue();
                return object;
            }
            if (log.isTraceEnabled()) {
                if (cacheValue == null) {
                    log.trace("Cache miss: " + key);
                } else {
                    log.trace("Cache value is not available in current transaction: " + key);
                }
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Locking: " + key);
        }
        try {
            this.cache.lock(key);
        }
        catch (Exception e) {
            return LOCK_FAILURE;
        }
        return LOCK_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Caching: " + key);
        }
        try {
            boolean puttable;
            this.cache.lock(key);
            CacheValue cacheValue = (CacheValue)this.cache.get(key);
            boolean bl = puttable = cacheValue == null || cacheValue.getVersion() != null && versionComparator.compare(cacheValue.getVersion(), version) < 0;
            if (puttable) {
                this.cache.put(key, (Object)new CacheValue(value, this.cache.nextTimestamp(), version));
                if (log.isTraceEnabled()) {
                    log.trace("Cached: " + key);
                }
                boolean bl2 = true;
                return bl2;
            }
            if (log.isTraceEnabled()) {
                if (cacheValue != null) {
                    log.trace("Item was already cached: " + key);
                } else {
                    log.trace("Cache value with newer version was found: " + key);
                }
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Releasing: " + key);
        }
        if (clientLock == LOCK_SUCCESS) {
            this.cache.unlock(key);
        }
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("Could not destroy cache", (Throwable)e);
        }
    }

    public void afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Updating: " + key);
        }
        this.cache.put(key, (Object)new CacheValue(value, this.cache.nextTimestamp(), version));
        if (log.isTraceEnabled()) {
            log.trace("Updated: " + key);
        }
    }

    public void afterInsert(Object key, Object value, Object version) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Inserting: " + key);
        }
        this.cache.put(key, (Object)new CacheValue(value, this.cache.nextTimestamp(), version));
        if (log.isTraceEnabled()) {
            log.trace("Inserted: " + key);
        }
    }

    public void evict(Object key) throws CacheException {
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        if (minimalPuts) {
            throw new HibernateException("minimal puts not supported for read-write cache");
        }
    }
}

