/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.hibernate;

import com.atlassian.cache.CacheManager;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.Timestamper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheHibernateProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheHibernateProvider.class);
    private final CacheManager cacheManager;

    public EhCacheHibernateProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Cache buildCache(String name, Properties properties) {
        log.debug("Creating Hibernate wrapper for cache '{}'", (Object)name);
        com.atlassian.cache.Cache cache = this.cacheManager.getCache(name);
        return new HibernateCacheWrapper(cache);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) {
    }

    public void stop() {
    }

    private static class HibernateCacheWrapper
    implements Cache {
        private final com.atlassian.cache.Cache cache;

        public HibernateCacheWrapper(com.atlassian.cache.Cache cache) {
            this.cache = cache;
        }

        public Object get(Object key) throws CacheException {
            return this.cache.get(key);
        }

        public void put(Object key, Object value) throws CacheException {
            this.cache.put(key, value);
        }

        public void remove(Object key) throws CacheException {
            this.cache.remove(key);
        }

        public void clear() throws CacheException {
            this.cache.removeAll();
        }

        public void destroy() throws CacheException {
        }

        public void lock(Object key) throws CacheException {
        }

        public void unlock(Object key) throws CacheException {
        }

        public long nextTimestamp() {
            return Timestamper.next();
        }

        public int getTimeout() {
            return 245760000;
        }
    }
}

