/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigReader;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigs;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

class EhCacheHistoricalConfigReader {
    private final URL historyZipResource = ClassLoaderUtils.getResource((String)"com/atlassian/confluence/cache/ehcache/config/migration/ehcache-xml-history.zip", this.getClass());

    EhCacheHistoricalConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<EhCacheConfigs> readHistoricalCacheConfigs() throws IOException, DocumentException {
        File tempFile = File.createTempFile(this.getClass().getSimpleName(), ".zip");
        try {
            Collection<EhCacheConfigs> collection;
            FileUtils.copyURLToFile((URL)this.historyZipResource, (File)tempFile);
            ZipFile zipFile = new ZipFile(tempFile);
            try {
                collection = EhCacheHistoricalConfigReader.extractCacheConfigsFromZipFile(zipFile);
            }
            catch (Throwable throwable) {
                zipFile.close();
                throw throwable;
            }
            zipFile.close();
            return collection;
        }
        finally {
            tempFile.delete();
        }
    }

    private static Collection<EhCacheConfigs> extractCacheConfigsFromZipFile(ZipFile zipFile) throws IOException, DocumentException {
        ArrayList results = Lists.newArrayList();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith("ehcache.xml")) continue;
            results.add(EhCacheConfigReader.extractCacheConfigs((Resource)new ZipEntryResource(zipFile, zipEntry)));
        }
        return results;
    }

    private static class ZipEntryResource
    extends AbstractResource {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;

        ZipEntryResource(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public String getDescription() {
            return "Entry " + this.zipEntry.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }
    }
}

