/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.EhCacheConfigStore;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigMigrationException;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigMigrationPredicate;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigReader;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigValidator;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigs;
import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheHistoricalConfigReader;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationCacheConfig;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationWarning;
import com.atlassian.confluence.setup.BootstrapManager;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class EhCacheConfigMigrator
implements Callable<Integer> {
    private static final Logger log = LoggerFactory.getLogger(EhCacheConfigMigrator.class);
    private static final String EHCACHE_LEGACY_COPY_FILENAME = "ehcache-legacy-copy.xml";
    private static final String MIGRATION_WARNING_LOG_FILENAME = "ehcache-migration-warnings.log";
    private static final String DISTRIBUTION_EHCACHE_XML_PATH = "/ehcache.xml";
    private static final String EHCACHE_XML_FILENAME = "ehcache.xml";
    private final EhCacheConfigStore ehCacheConfigStore;
    private final File siteEhCacheXmlFile;

    public EhCacheConfigMigrator(BootstrapManager bootstrapManager, EhCacheConfigStore ehCacheConfigStore) {
        this.ehCacheConfigStore = ehCacheConfigStore;
        this.siteEhCacheXmlFile = new File(bootstrapManager.getConfluenceHome() + File.separatorChar + "config" + File.separatorChar + EHCACHE_XML_FILENAME);
    }

    @Override
    public Integer call() throws EhCacheConfigMigrationException {
        return this.migrateConfig().getMigratedCacheCount();
    }

    public MigrationResult migrateConfig() throws EhCacheConfigMigrationException {
        if (this.siteEhCacheXmlFile.isFile()) {
            try {
                MigrationResult migrationResult = this.doMigrateConfig();
                if (migrationResult.hasWarnings()) {
                    this.keepLegacyConfigCopyAndLogDiagnostics(migrationResult.getWarnings());
                } else {
                    log.info("EhCache config has been fully migrated; removing old config file at {}", (Object)this.siteEhCacheXmlFile.getAbsolutePath());
                    EhCacheConfigMigrator.removeLegacyConfigFile(this.siteEhCacheXmlFile);
                }
                return migrationResult;
            }
            catch (DocumentException ex) {
                this.keepLegacyConfigCopyAndLogDiagnostics(Collections.EMPTY_LIST);
                throw new EhCacheConfigMigrationException("Failed to parse " + this.siteEhCacheXmlFile.getAbsolutePath() + ", cannot migrate ehcache config", ex);
            }
            catch (IOException ex) {
                this.keepLegacyConfigCopyAndLogDiagnostics(Collections.EMPTY_LIST);
                throw new EhCacheConfigMigrationException("Failed to read " + this.siteEhCacheXmlFile.getAbsolutePath() + ", cannot migrate ehcache config", ex);
            }
        }
        log.info("No {} file found to migrate. Nothing to do.", (Object)this.siteEhCacheXmlFile.getAbsolutePath());
        return new MigrationResult(0, Collections.EMPTY_LIST);
    }

    private MigrationResult doMigrateConfig() throws IOException, DocumentException {
        EhCacheConfigs siteCacheConfigs = this.getSiteCacheConfigs();
        EhCacheConfigs distributionCacheConfigs = EhCacheConfigMigrator.getDistributionCacheConfigs();
        Collection<MigrationWarning> migrationWarnings = this.validateSiteCacheConfig(siteCacheConfigs, distributionCacheConfigs);
        EhCacheConfigMigrationPredicate migrationPredicate = new EhCacheConfigMigrationPredicate(distributionCacheConfigs);
        Properties migratedConfig = EhCacheConfigMigrator.getMigratedConfig(Iterables.filter(siteCacheConfigs.getNamedCaches(), (Predicate)migrationPredicate));
        this.ehCacheConfigStore.updateStoredConfig(migratedConfig);
        return new MigrationResult(migratedConfig.size(), migrationWarnings);
    }

    private static EhCacheConfigs getDistributionCacheConfigs() throws IOException, DocumentException {
        return EhCacheConfigReader.extractCacheConfigs((Resource)new ClassPathResource(DISTRIBUTION_EHCACHE_XML_PATH));
    }

    private EhCacheConfigs getSiteCacheConfigs() throws IOException, DocumentException {
        return EhCacheConfigReader.extractCacheConfigs((Resource)new FileSystemResource(this.siteEhCacheXmlFile));
    }

    private Collection<MigrationWarning> validateSiteCacheConfig(EhCacheConfigs siteCacheConfigs, EhCacheConfigs distributionCacheConfigs) throws IOException, DocumentException {
        EhCacheConfigValidator validator = new EhCacheConfigValidator(distributionCacheConfigs, new EhCacheHistoricalConfigReader().readHistoricalCacheConfigs());
        return validator.validateSiteCacheConfigs(siteCacheConfigs);
    }

    private void keepLegacyConfigCopyAndLogDiagnostics(Collection<MigrationWarning> warnings) {
        File legacyCopy = new File(this.siteEhCacheXmlFile.getParent(), EHCACHE_LEGACY_COPY_FILENAME);
        File migrationWarningLog = new File(this.siteEhCacheXmlFile.getParent(), MIGRATION_WARNING_LOG_FILENAME);
        try {
            FileUtils.copyFile((File)this.siteEhCacheXmlFile, (File)legacyCopy);
            EhCacheConfigMigrator.removeLegacyConfigFile(this.siteEhCacheXmlFile);
        }
        catch (IOException e) {
            log.warn("Copy of legacy ehcache.xml file could not be taken", (Throwable)e);
        }
        if (!warnings.isEmpty()) {
            try {
                FileUtils.writeLines((File)migrationWarningLog, (Collection)Collections2.transform(warnings, (Function)Functions.toStringFunction()));
            }
            catch (IOException e) {
                log.warn("Migration warning log file could not be created", (Throwable)e);
            }
        }
    }

    private static void removeLegacyConfigFile(File ehCacheXmlFile) {
        if (!ehCacheXmlFile.delete()) {
            log.warn("Failed to delete legacy ehcache.xml config file. Please delete manually when possible: {}", (Object)ehCacheXmlFile.getAbsolutePath());
        }
    }

    private static Properties getMigratedConfig(Iterable<MigrationCacheConfig> siteCacheConfigsToBeMigrated) {
        Properties migratedCacheProperties = new Properties();
        for (MigrationCacheConfig siteCacheConfig : siteCacheConfigsToBeMigrated) {
            String propertyName = "cache.maxEntriesLocalHeap." + siteCacheConfig.name;
            String propertyValue = siteCacheConfig.maxElementsInMemory;
            if (StringUtils.isNumeric((CharSequence)propertyValue)) {
                migratedCacheProperties.setProperty(propertyName, propertyValue);
                continue;
            }
            log.warn("Non-numeric value found for 'maxElementsInMemory'. Skipping migration of this cache: {}", (Object)siteCacheConfig);
        }
        return migratedCacheProperties;
    }

    public static class MigrationResult {
        private final int migratedCacheCount;
        private final Collection<MigrationWarning> warnings;

        public MigrationResult(int migratedCacheCount, Collection<MigrationWarning> warnings) {
            this.migratedCacheCount = migratedCacheCount;
            this.warnings = warnings;
        }

        public int getMigratedCacheCount() {
            return this.migratedCacheCount;
        }

        public Collection<MigrationWarning> getWarnings() {
            return this.warnings;
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

