/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.config.migration.MigrationCacheConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

class EhCacheConfigs {
    private final String source;
    private final MigrationCacheConfig defaultCache;
    private final Map<String, MigrationCacheConfig> namedCaches;

    EhCacheConfigs(String source, MigrationCacheConfig defaultCache, Collection<MigrationCacheConfig> namedCaches) {
        this.source = source;
        this.defaultCache = defaultCache;
        this.namedCaches = Maps.newLinkedHashMap();
        for (MigrationCacheConfig namedCache : namedCaches) {
            Preconditions.checkState((!this.namedCaches.containsKey(namedCache.name) ? 1 : 0) != 0, (Object)("Multiple cache configs found with name '" + namedCache.name + "'"));
            this.namedCaches.put(namedCache.name, namedCache);
        }
    }

    String getSource() {
        return this.source;
    }

    boolean matchesDefaultCacheExactly(MigrationCacheConfig otherCache) {
        return otherCache.equals(this.defaultCache);
    }

    boolean matchesDefaultCache(MigrationCacheConfig otherCache) {
        return otherCache.equalsExcludingName(this.defaultCache);
    }

    MigrationCacheConfig getDefaultCache() {
        return this.defaultCache;
    }

    MigrationCacheConfig getNamedCache(String name) {
        return this.namedCaches.get(name);
    }

    boolean hasNamedCache(String name) {
        return this.getNamedCache(name) != null;
    }

    Collection<MigrationCacheConfig> getNamedCaches() {
        return this.namedCaches.values();
    }

    MigrationCacheConfig getCorrespondingCacheConfig(MigrationCacheConfig siteCacheConfig) {
        return this.hasNamedCache(siteCacheConfig.name) ? this.getNamedCache(siteCacheConfig.name) : this.getDefaultCache();
    }
}

