/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigs;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationCacheConfig;
import com.google.common.base.Predicate;

class EhCacheConfigMigrationPredicate
implements Predicate<MigrationCacheConfig> {
    private final EhCacheConfigs distroCacheConfigs;

    public EhCacheConfigMigrationPredicate(EhCacheConfigs distroCacheConfigs) {
        this.distroCacheConfigs = distroCacheConfigs;
    }

    public boolean apply(MigrationCacheConfig siteCacheConfig) {
        return this.shouldSiteCacheConfigBeMigrated(siteCacheConfig);
    }

    private boolean shouldSiteCacheConfigBeMigrated(MigrationCacheConfig siteCache) {
        MigrationCacheConfig baselineConfig = this.distroCacheConfigs.getCorrespondingCacheConfig(siteCache);
        boolean siteCacheConfigRequiresMigration = !siteCache.matchesMigratablePropertiesOf(baselineConfig);
        return siteCacheConfigRequiresMigration;
    }
}

