/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.ConfigurableCache;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class ConfluenceEhCache
implements ConfigurableCache {
    private final Cache delegate;

    public ConfluenceEhCache(Cache delegate) {
        this.delegate = delegate;
    }

    public Object get(Object key) {
        Element element = this.delegate.get(key);
        return element == null ? null : element.getObjectValue();
    }

    public Collection<Object> getKeys() {
        return this.delegate.getKeys();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void put(Object key, Object value) {
        this.delegate.put(new Element(key, value));
    }

    public void remove(Object key) {
        this.delegate.remove(key);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeunit is required.");
        }
        if (timeToLive < 0L) {
            throw new IllegalArgumentException("time to live must be greater than or equal to 0.");
        }
        this.delegate.getCacheConfiguration().setTimeToLiveSeconds(timeUnit.toSeconds(timeToLive));
    }
}

