/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.CacheConfigManager;
import com.atlassian.confluence.cache.ehcache.EhCacheConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.store.SizeAdjustable;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.parsers.SAXParser;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.XMLReader;

public class EhCacheConfigManager
implements CacheConfigManager {
    private final EhCacheConfig ehCacheConfig;
    private final CacheManager cacheManager;

    public EhCacheConfigManager(EhCacheConfig ehCacheConfig, CacheManager cacheManager) {
        this.ehCacheConfig = ehCacheConfig;
        this.cacheManager = cacheManager;
    }

    public void changeMaxCacheSize(String cacheName, int newMaxCacheSize) {
        Document config = this.readDocument();
        Node cacheConfig = config.selectSingleNode("//cache[@name='" + cacheName + "']");
        if (cacheConfig != null && cacheConfig instanceof Element) {
            ((Element)cacheConfig).addAttribute("maxElementsInMemory", Integer.toString(newMaxCacheSize));
        } else if (cacheConfig == null) {
            Node defaultConfig = config.selectSingleNode("//defaultCache");
            Element newConfig = (Element)defaultConfig.clone();
            newConfig.setName("cache");
            newConfig.addAttribute("name", cacheName);
            newConfig.addAttribute("maxElementsInMemory", Integer.toString(newMaxCacheSize));
            config.getRootElement().add(newConfig);
        }
        this.saveConfig(config);
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null && cache.getMemoryStore() instanceof SizeAdjustable) {
            cache.getCacheConfiguration().setMaxElementsInMemory(newMaxCacheSize);
            ((SizeAdjustable)cache.getMemoryStore()).setMaxSize(newMaxCacheSize);
        }
    }

    private Document readDocument() {
        Document document;
        SAXReader saxReader = new SAXReader((XMLReader)new SAXParser());
        InputStream inputStream = null;
        try {
            inputStream = this.ehCacheConfig.getInputStream();
            document = saxReader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException("Error parsing cache config file.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig(Document config) {
        boolean renameSuccessful;
        FileOutputStream outputStream;
        File tempFile;
        try {
            tempFile = File.createTempFile("ehcache", null, this.ehCacheConfig.getFile().getParentFile());
            outputStream = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temp file.", e);
        }
        try {
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, OutputFormat.createPrettyPrint());
            writer.write(config);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading or writing to cache config file.", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        EhCacheConfigManager ehCacheConfigManager = this;
        synchronized (ehCacheConfigManager) {
            this.ehCacheConfig.getFile().delete();
            renameSuccessful = tempFile.renameTo(this.ehCacheConfig.getFile());
        }
        if (!renameSuccessful) {
            throw new RuntimeException("Could not save config changes from temp file " + tempFile.getAbsolutePath() + " to home directory");
        }
        tempFile.delete();
    }
}

