/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class EhCacheConfig {
    private static final String CONFIG_FILENAME = "ehcache.xml";
    private final String configFilePath;

    public EhCacheConfig(BootstrapManager bootstrapManager) {
        this.configFilePath = bootstrapManager.getConfluenceHome() + File.separatorChar + "config" + File.separatorChar + CONFIG_FILENAME;
        this.ensureConfigurationFileCreated();
    }

    public File getFile() {
        return new File(this.configFilePath);
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(new File(this.configFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureConfigurationFileCreated() {
        File file = new File(this.configFilePath);
        if (!file.exists()) {
            this.copyCacheConfigToHomeDir(CONFIG_FILENAME, file);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyCacheConfigToHomeDir(String configFileName, File file) {
        InputStream inputStream = ClassLoaderUtils.getResourceAsStream((String)configFileName, this.getClass());
        FileOutputStream fileOutputStream = null;
        try {
            this.ensureParentDirExists(file);
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("Error creating cache configuration file: " + file.getPath(), e);
                catch (IOException e2) {
                    throw new RuntimeException("Error creating cache configuration file: " + file.getPath(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private void ensureParentDirExists(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
    }
}

