package com.atlassian.configurable;

import org.dom4j.Element;

import java.util.List;
import java.util.Iterator;

/**
 * Uses an xml element to configure a list of keys and values as the available values for this property.
 */
public class XMLValuesObjectConfigurationProperty extends ObjectConfigurationPropertyImpl
{
    /**
     * Creates a new XMLValuesObjectConfigurationProperty object.
     *
     * @param name         DOCUMENT ME!
     * @param description  DOCUMENT ME!
     * @param defaultValue DOCUMENT ME!
     * @param type         DOCUMENT ME!
     * @param element      DOCUMENT ME!
     */
    XMLValuesObjectConfigurationProperty(String name, String description, String defaultValue, int type, Element element, String enabledConditionClassName)
    {
        super(name, description, defaultValue, type, enabledConditionClassName);

        //This element will contain multiple value tags containing a key and a value
        if (element != null)
        {
            List elements = element.elements("value");

            for (Iterator iterator = elements.iterator(); iterator.hasNext();)
            {
                Element valueElement = (Element) iterator.next();

                //This value element contains a key and value element
                Element keyElement = valueElement.element("key");
                Element keyValueElement = valueElement.element("value");

                getMutableInternalValues().put(keyElement.getTextTrim(), keyValueElement.getTextTrim());
            }
        }
    }
}