/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.testutil.spec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.testutil.spec.SpecExample;

public class SpecReader {
    private static final Pattern SECTION_PATTERN = Pattern.compile("#{1,6} *(.*)");
    private final InputStream inputStream;
    private State state = State.BEFORE;
    private String section;
    private StringBuilder source;
    private StringBuilder html;
    private int exampleNumber = 0;
    private List<SpecExample> examples = new ArrayList<SpecExample>();

    private SpecReader(InputStream stream) {
        this.inputStream = stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SpecExample> readExamples() {
        try (InputStream stream = SpecReader.getSpecInputStream();){
            List<SpecExample> list = new SpecReader(stream).read();
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readExamplesAsString() {
        List<SpecExample> examples = SpecReader.readExamples();
        ArrayList<String> result = new ArrayList<String>();
        for (SpecExample example : examples) {
            result.add(example.getSource());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSpec() {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SpecReader.getSpecInputStream(), Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getSpecInputStream() {
        InputStream stream = SpecReader.class.getResourceAsStream("/spec.txt");
        if (stream == null) {
            throw new IllegalStateException("Could not load spec.txt classpath resource");
        }
        return stream;
    }

    private List<SpecExample> read() throws IOException {
        this.resetContents();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        return this.examples;
    }

    private void processLine(String line) {
        switch (this.state) {
            case BEFORE: {
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    this.section = matcher.group(1);
                    this.exampleNumber = 0;
                }
                if (!line.equals("```````````````````````````````` example")) break;
                this.state = State.SOURCE;
                ++this.exampleNumber;
                break;
            }
            case SOURCE: {
                if (line.equals(".")) {
                    this.state = State.HTML;
                    break;
                }
                String processedLine = line.replace('\u2192', '\t');
                this.source.append(processedLine).append('\n');
                break;
            }
            case HTML: {
                if (line.equals("````````````````````````````````")) {
                    this.state = State.BEFORE;
                    this.examples.add(new SpecExample(this.section, this.exampleNumber, this.source.toString(), this.html.toString()));
                    this.resetContents();
                    break;
                }
                this.html.append(line).append('\n');
            }
        }
    }

    private void resetContents() {
        this.source = new StringBuilder();
        this.html = new StringBuilder();
    }

    private static enum State {
        BEFORE,
        SOURCE,
        HTML;

    }
}

