/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.front.matter.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import org.commonmark.ext.front.matter.YamlFrontMatterNode;
import org.commonmark.internal.DocumentBlockParser;
import org.commonmark.node.Block;
import org.commonmark.node.Node;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class YamlFrontMatterBlockParser
extends AbstractBlockParser {
    private static final Pattern REGEX_METADATA = Pattern.compile("^[ ]{0,3}([A-Za-z0-9_-]+):\\s*(.*)");
    private static final Pattern REGEX_METADATA_LIST = Pattern.compile("^[ ]+-\\s*(.*)");
    private static final Pattern REGEX_METADATA_LITERAL = Pattern.compile("^\\s*(.*)");
    private static final Pattern REGEX_BEGIN = Pattern.compile("^-{3}(\\s.*)?");
    private static final Pattern REGEX_END = Pattern.compile("^(-{3}|\\.{3})(\\s.*)?");
    private boolean inLiteral = false;
    private String currentKey = null;
    private List<String> currentValues = new ArrayList<String>();
    private YamlFrontMatterBlock block = new YamlFrontMatterBlock();

    public Block getBlock() {
        return this.block;
    }

    public void addLine(CharSequence line) {
    }

    public BlockContinue tryContinue(ParserState parserState) {
        CharSequence line = parserState.getLine();
        if (REGEX_END.matcher(line).matches()) {
            if (this.currentKey != null) {
                this.block.appendChild((Node)new YamlFrontMatterNode(this.currentKey, this.currentValues));
            }
            return BlockContinue.finished();
        }
        Matcher matcher = REGEX_METADATA.matcher(line);
        if (matcher.matches()) {
            if (this.currentKey != null) {
                this.block.appendChild((Node)new YamlFrontMatterNode(this.currentKey, this.currentValues));
            }
            this.inLiteral = false;
            this.currentKey = matcher.group(1);
            this.currentValues = new ArrayList<String>();
            if ("|".equals(matcher.group(2))) {
                this.inLiteral = true;
            } else if (!"".equals(matcher.group(2))) {
                this.currentValues.add(matcher.group(2));
            }
            return BlockContinue.atIndex((int)parserState.getIndex());
        }
        if (this.inLiteral) {
            matcher = REGEX_METADATA_LITERAL.matcher(line);
            if (matcher.matches()) {
                if (this.currentValues.size() == 1) {
                    this.currentValues.set(0, this.currentValues.get(0) + "\n" + matcher.group(1).trim());
                } else {
                    this.currentValues.add(matcher.group(1).trim());
                }
            }
        } else {
            matcher = REGEX_METADATA_LIST.matcher(line);
            if (matcher.matches()) {
                this.currentValues.add(matcher.group(1));
            }
        }
        return BlockContinue.atIndex((int)parserState.getIndex());
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence line = state.getLine();
            BlockParser parentParser = matchedBlockParser.getMatchedBlockParser();
            if (parentParser instanceof DocumentBlockParser && parentParser.getBlock().getFirstChild() == null && REGEX_BEGIN.matcher(line).matches()) {
                return BlockStart.of((BlockParser[])new BlockParser[]{new YamlFrontMatterBlockParser()}).atIndex(state.getNextNonSpaceIndex());
            }
            return BlockStart.none();
        }
    }
}

