/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.heading.anchor.internal;

import java.util.ArrayList;
import java.util.Map;
import org.commonmark.ext.heading.anchor.IdGenerator;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Code;
import org.commonmark.node.Heading;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.html.AttributeProvider;

public class HeadingIdAttributeProvider
implements AttributeProvider {
    private final IdGenerator idGenerator;

    private HeadingIdAttributeProvider(String defaultId, String prefix, String suffix) {
        this.idGenerator = IdGenerator.builder().defaultId(defaultId).prefix(prefix).suffix(suffix).build();
    }

    public static HeadingIdAttributeProvider create(String defaultId, String prefix, String suffix) {
        return new HeadingIdAttributeProvider(defaultId, prefix, suffix);
    }

    public void setAttributes(Node node, String tagName, Map<String, String> attributes) {
        if (node instanceof Heading) {
            final ArrayList wordList = new ArrayList();
            node.accept((Visitor)new AbstractVisitor(){

                public void visit(Text text) {
                    wordList.add(text.getLiteral());
                }

                public void visit(Code code) {
                    wordList.add(code.getLiteral());
                }
            });
            String finalString = "";
            for (String word : wordList) {
                finalString = finalString + word;
            }
            finalString = finalString.trim().toLowerCase();
            attributes.put("id", this.idGenerator.generateId(finalString));
        }
    }
}

