/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class TableNodeRenderer
implements NodeRenderer {
    private final HtmlWriter htmlWriter;
    private final HtmlNodeRendererContext context;

    public TableNodeRenderer(HtmlNodeRendererContext context) {
        this.htmlWriter = context.getWriter();
        this.context = context;
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return new HashSet<Class<? extends Node>>(Arrays.asList(TableBlock.class, TableHead.class, TableBody.class, TableRow.class, TableCell.class));
    }

    public void render(Node node) {
        if (node instanceof TableBlock) {
            this.renderBlock((TableBlock)node);
        } else if (node instanceof TableHead) {
            this.renderHead((TableHead)node);
        } else if (node instanceof TableBody) {
            this.renderBody((TableBody)node);
        } else if (node instanceof TableRow) {
            this.renderRow((TableRow)node);
        } else if (node instanceof TableCell) {
            this.renderCell((TableCell)node);
        }
    }

    private void renderBlock(TableBlock tableBlock) {
        this.htmlWriter.line();
        this.htmlWriter.tag("table", this.getAttributes((Node)tableBlock));
        this.renderChildren((Node)tableBlock);
        this.htmlWriter.tag("/table");
        this.htmlWriter.line();
    }

    private void renderHead(TableHead tableHead) {
        this.htmlWriter.line();
        this.htmlWriter.tag("thead", this.getAttributes((Node)tableHead));
        this.renderChildren((Node)tableHead);
        this.htmlWriter.tag("/thead");
        this.htmlWriter.line();
    }

    private void renderBody(TableBody tableBody) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tbody", this.getAttributes((Node)tableBody));
        this.renderChildren((Node)tableBody);
        this.htmlWriter.tag("/tbody");
        this.htmlWriter.line();
    }

    private void renderRow(TableRow tableRow) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tr", this.getAttributes((Node)tableRow));
        this.renderChildren((Node)tableRow);
        this.htmlWriter.tag("/tr");
        this.htmlWriter.line();
    }

    private void renderCell(TableCell tableCell) {
        String tag = tableCell.isHeader() ? "th" : "td";
        this.htmlWriter.tag(tag, this.getCellAttributes(tableCell));
        this.renderChildren((Node)tableCell);
        this.htmlWriter.tag("/" + tag);
    }

    private Map<String, String> getAttributes(Node node) {
        return this.context.extendAttributes(node, Collections.emptyMap());
    }

    private Map<String, String> getCellAttributes(TableCell tableCell) {
        if (tableCell.getAlignment() != null) {
            return this.context.extendAttributes((Node)tableCell, Collections.singletonMap("align", TableNodeRenderer.getAlignValue(tableCell.getAlignment())));
        }
        return this.context.extendAttributes((Node)tableCell, Collections.emptyMap());
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

