/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables;

import java.util.Collections;
import java.util.Map;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.html.CustomHtmlRenderer;
import org.commonmark.html.HtmlWriter;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;

public class TableHtmlRenderer
implements CustomHtmlRenderer {
    public boolean render(Node node, HtmlWriter htmlWriter, Visitor visitor) {
        if (node instanceof TableBlock) {
            this.renderBlock((TableBlock)node, htmlWriter, visitor);
        } else if (node instanceof TableHead) {
            this.renderHead((TableHead)node, htmlWriter, visitor);
        } else if (node instanceof TableBody) {
            this.renderBody((TableBody)node, htmlWriter, visitor);
        } else if (node instanceof TableRow) {
            this.renderRow((TableRow)node, htmlWriter, visitor);
        } else if (node instanceof TableCell) {
            this.renderCell((TableCell)node, htmlWriter, visitor);
        } else {
            return false;
        }
        return true;
    }

    private void renderBlock(TableBlock tableBlock, HtmlWriter htmlWriter, Visitor visitor) {
        htmlWriter.line();
        htmlWriter.tag("table");
        this.visitChildren((Node)tableBlock, visitor);
        htmlWriter.tag("/table");
        htmlWriter.line();
    }

    private void renderHead(TableHead tableHead, HtmlWriter htmlWriter, Visitor visitor) {
        htmlWriter.line();
        htmlWriter.tag("thead");
        this.visitChildren((Node)tableHead, visitor);
        htmlWriter.tag("/thead");
        htmlWriter.line();
    }

    private void renderBody(TableBody tableBody, HtmlWriter htmlWriter, Visitor visitor) {
        htmlWriter.line();
        htmlWriter.tag("tbody");
        this.visitChildren((Node)tableBody, visitor);
        htmlWriter.tag("/tbody");
        htmlWriter.line();
    }

    private void renderRow(TableRow tableRow, HtmlWriter htmlWriter, Visitor visitor) {
        htmlWriter.line();
        htmlWriter.tag("tr");
        this.visitChildren((Node)tableRow, visitor);
        htmlWriter.tag("/tr");
        htmlWriter.line();
    }

    private void renderCell(TableCell tableCell, HtmlWriter htmlWriter, Visitor visitor) {
        String tag = tableCell.isHeader() ? "th" : "td";
        htmlWriter.tag(tag, TableHtmlRenderer.getAttributes(tableCell));
        this.visitChildren((Node)tableCell, visitor);
        htmlWriter.tag("/" + tag);
    }

    private static Map<String, String> getAttributes(TableCell tableCell) {
        if (tableCell.getAlignment() != null) {
            return Collections.singletonMap("align", TableHtmlRenderer.getAlignValue(tableCell.getAlignment()));
        }
        return Collections.emptyMap();
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    private void visitChildren(Node node, Visitor visitor) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            child.accept(visitor);
        }
    }
}

