/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.mapper;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.cmpt.check.mapper.DuplicateEmailDataProvider;
import com.atlassian.cmpt.check.mapper.DuplicateOccurence;
import java.util.List;
import java.util.stream.Collectors;

public class EmailDuplicateMapper
extends AbstractMapper {
    private final DuplicateEmailDataProvider dataProvider;

    public EmailDuplicateMapper(DuplicateEmailDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void inject(CheckResultDto dto, CheckResult checkResult) {
        List<EmailDuplicate> violations;
        String description;
        switch (dto.getStatus()) {
            case SUCCESS: {
                description = "All users have unique email addresses";
                break;
            }
            case ERROR: 
            case WARNING: {
                description = "Multiple users have the same email address";
                break;
            }
            case RUNNING: {
                description = "Checking for duplicate email addresses";
                break;
            }
            case EXECUTION_ERROR: {
                description = "We couldn\u2019t check for duplicate email addresses";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
        dto.setDescription(description);
        if (checkResult != null && !(violations = EmailDuplicateChecker.retrieveEmailDuplicates(checkResult.details)).isEmpty()) {
            List duplicateOccurrences = violations.stream().map((? super T violation) -> new DuplicateOccurence(violation.email, this.dataProvider.getUrlForUsersByEmail(violation.email), EmailDuplicateMapper.create(violation.ids))).collect(Collectors.toList());
            int numberOfOccurences = violations.stream().filter(violation -> violation.ids.size() > 1).mapToInt(violation -> violation.ids.size()).sum();
            CheckDetailsDto details = new CheckDetailsDto();
            details.setListOfOccurrences(duplicateOccurrences);
            dto.setDetails(details);
            dto.setNumberOfOccurrences(numberOfOccurences);
        }
    }

    private static List<DuplicateOccurence.DuplicateUsername> create(List<String> ids) {
        return ids.stream().map(DuplicateOccurence.DuplicateUsername::new).collect(Collectors.toList());
    }
}

