/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.mapper;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.LinkDto;
import com.atlassian.cmpt.check.mapper.AbstractMapper;

public class AppOutdatedMapper
extends AbstractMapper {
    private final String upmLink;

    public AppOutdatedMapper(String upmLink) {
        this.upmLink = upmLink;
    }

    @Override
    public void inject(CheckResultDto dto, CheckResult checkResult) {
        switch (dto.getStatus()) {
            case SUCCESS: {
                dto.setDescription("The Cloud Migration Assistant is up to date");
                break;
            }
            case ERROR: 
            case WARNING: {
                dto.setDescription("The Cloud Migration Assistant is out of date");
                dto.setLink(new LinkDto("Update to continue", this.upmLink));
                break;
            }
            case RUNNING: {
                dto.setDescription("Checking version of Cloud Migration Assistant");
                break;
            }
            case EXECUTION_ERROR: {
                dto.setDescription("We couldn\u2019t check the version of the Cloud Migration Assistant");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
    }
}

